<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Test\Logger;
use Mnv\Core\Locale\Charset;
use Mnv\Core\Locale\LanguageSelection;

use Mnv\Models\Languages;

/**
 * Class LanguageAdmin
 * @package Mnv\Admin\Controllers
 */
class LanguageAdmin extends AdminMnv
{

    public function fetch()
    {
        global $LANGUAGES;

        $language = new Languages($this->request);

        $this->smarty->assign('activeItem','languages');
        $this->smarty->assign('title', lang('languages:title'));

        if (count($LANGUAGES) > 0) {
            $this->smarty->assign('adminLangs', getLanguages());
        }

        /** если не существует ни одной версии языка то первый добавленный делаем по умолчанию */
        if ($language->isMultiLang()) {
            $language->data['isDefault'] = 1;
            $multiLang['isDefault'] = true;
            $this->smarty->assign('multiLang', $multiLang);
        }

        /** добавление  */
        if ($this->action == 'add' || $this->action == 'edit') {

            $language->edit()->gettingInfoAboutUsers();
        }
        /** сохранение */
        else  if ($this->action == 'save') {

            if (empty($language->data['languageName'])) {
                $this->errors['languageName'] = true;
            }
//            if (preg_match('/[^a-zA-Z]/', $language->data['languageName'])) {
//                $this->errors['languageNameCharacters'] = true;
//            }

            if (empty($language->id)) {
                /* check codename only for new languages */
                $language->data['codename'] = strtolower(trim($language->data['codename']));
                if (empty($language->data['codename'])) {
                    $this->errors['codename'] = true;
                }
                if ($codeName = $language->checkFileName($language->data['codename'])) {
                    if ($codeName == $language->data['codename']) {
                        $this->errors['codenameExists'] = true;
                    } else {
                        $language->data['codename'] = $codeName;
                    }
                }
                if (preg_match('/[^a-z]/', $language->data['codename'])) {
                    $this->errors['codenameCharacters'] = true;
                }
            }

            if (empty($this->errors)) {
                if ($language->prepare($language->data, $this->manager['userId'])) {
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $language->edit()->gettingInfoAboutUsers();


            if (empty($this->errors)) {
                redirect($this->adminUrl . '/langs');
            }
        }

        $this->smarty->assign('language', $language->data);
        $this->smarty->assign('languageOptions',    LanguageSelection::$languageOptions);
        $this->smarty->assign('languageCharsets',   Charset::$languageCharsets);
        $this->smarty->assign('charsetOptions',     Charset::$charsetOptions);



        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('langs')) {
            return $this->smarty->fetch('views/languages/language.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }
}



