<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\Maps;

/**
 * Class MapsAdmin
 * @package Mnv\Admin\Controllers
 */
class MapsAdmin extends AdminMnv
{

    public function fetch()
    {
        $maps = new Maps($this->request);

        $this->smarty->assign('activeItem','maps');
        $this->smarty->assign('title', lang('settings:title'));
        $this->smarty->assign('works', lang('general:works'));


        if (($this->action == 'save') && $maps->prepare($maps->data, $this->manager['userId'])) {
            $this->messages['saved'] = true;
        }

        $maps->edit();

        $this->smarty->assign('map', $maps->data);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('maps')) {
            return $this->smarty->fetch('views/maps/maps.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }
}


