<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Models\Shop\Colors;


/**
 * Class ProductColorAdmin
 * @package Mnv\Admin\Controllers
 */
class ProductColorAdmin extends AdminMnv
{
    /**
     * @var string
     */
    private $typeContent;

    public function fetch()
    {
        $colors = new Colors($this->request);


        $image    = $this->request->get('image', '');
        $imageId = (int) $this->request->get('imageId');

        $this->typeContent   = $this->module .'s';
        $this->smarty->assign('activeItem', $this->typeContent);
        $this->smarty->assign('title', 'Цвета');
        /* statuses */
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $this->module . 's');

        if ($this->action == 'add' || $this->action == 'edit') {
            $colors->edit()->getFiles();
        } else if ($this->action == 'save' || $this->action == 'apply') {

            /** проверка полей */
            if (empty($colors->data['colorName'])) $this->errors['title'] = true;
            if (!empty($image['fileId'])) $images['fileId'] = $image['fileId'];

            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {
                if ($colors->prepare($colors->data, $this->module, $this->manager['userId'])) {
                    if (!empty($images['fileId'])) $colors->addMainImage($colors->id, $images);
                    $this->messages['saved'] = true;

                } else {
                    $this->errors['not_saved'] = true;
                }

            }

            $colors->edit()->getFiles();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->adminUrl . "/" . $this->typeContent . "?" . $this->buildQueryString(['page' => $this->page]));
            }

        }
        else if ($this->action == 'deleteImage') {

            $result = $colors->deleteFile($imageId)
                ? array('status' => 200, 'message' => lang('javascript:deletingImage'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:deletingImageError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }


        $this->smarty->assign('color', $colors->data);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if ($this->permissions($this->module.'s')) {
            return $this->smarty->fetch('views/shop/' . $this->module .'.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }



}