<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Models\Shop\Options;

/**
 * Class CarOptionsAdmin
 * @package Mnv\Admin\Controllers
 */
class ProductOptionsAdmin extends AdminMnv
{

    public function fetch()
    {
        $option = new Options($this->request);

        /** title */
        $this->smarty->assign('title', 'Свойства опций');
        /** activeItem */
        $this->smarty->assign('activeItem', 'options');
        /** statuses */
        $this->smarty->assign('statuses', lang('general:statuses'));
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $this->module);

        
        /** действия */
        if ($this->action == 'remove') {
            $result = $option->remove()
                ? array('status' => 200, 'message' => 'Опция удалена' , 'type' => 'success')
                : array('status' => 403, 'message' => 'Опция НЕ удалена', 'type' => 'error');
            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** изменение статуса */
        else if ($this->action == 'status') {

            $result = $option->status()
                ? array('data' => true, 'status' => $option->status, 'type' => 'success')
                : array('data' => false, 'status' => $option->status, 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        } else if ($this->action == 'reorder') {
            $i = 0;
            $option->data = [];
            print_r($option->optionIds);
            foreach ($option->optionIds as $optionId) {
                $i++;
                $option->id = $optionId;
                $option->data['orderBy'] = $i;
                $option->update($option->data);
            }

            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;

        }
        else {

            /** фильтровать контента */
            $option->filter = array_filter([
                'status'        => $this->status,
                'query'         => $this->query,
            ]);

            $options = collect($option->all($this->limit, $this->page))->map(function ($item) use ($option) {
                $item['statusName'] = lang('general:statuses:' . $item['status']);

                return $item;
            })->all();

            /** Получение кол-во статей */

            /** pagination */
            $option->total();
            $pages = getPageNums($option->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalArticles', $option->total);
            $this->smarty->assign('options', $options);
            $this->smarty->assign('pageNums', $pages);

            $this->smarty->assign('page', $this->page);
        }

        /** Права доступа к данному шаблону */
        if ($this->permissions('options')) {
            return $this->smarty->fetch('views/shop/options.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }


}