<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\Socials;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class SocialAdmin
 * @package Mnv\Admin\Controllers
 */
class SocialAdmin extends AdminMnv
{

    public function fetch()
    {
        $social = new Socials($this->request);

        $this->smarty->assign('activeItem','socials');
        $this->smarty->assign('title', lang('settings:social'));

        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1, 2));

        if ($this->action == 'add' || $this->action == 'edit') {

            $social->edit()->gettingInfoAboutUsers();

        } else if ($this->action == 'save' || $this->action == 'apply') {

            if (empty($social->data['name'])) $this->errors['errorName'] = true;
            if (empty($social->data['fileName'])) $this->errors['fileNameEmpty'] = true;
            if (!$social->checkFileName($social->data['fileName'])) $this->errors['fileNameError'] = true;

            if (empty($this->errors)) {
                if ($social->prepare($social->data, $this->manager['userId'])) {
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $social->edit()->gettingInfoAboutUsers();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->adminUrl . "/socials?" . $this->buildQueryString(['page' => $this->page]));
            }
        }

        $this->smarty->assign('social', $social->data);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('socials')) {
            return $this->smarty->fetch('views/socials/social.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }


}



