<?php

namespace Mnv\Admin\Controllers;

use Mnv\Core\AdminMnv;
use Mnv\Models\TelegramNotification;

/**
 * Class TelegramNotificationAdmin
 * @package Mnv\Admin\Controllers
 */
class TelegramNotificationAdmin extends AdminMnv
{

    public function fetch()
    {

        $telegram = new TelegramNotification($this->request);

        $this->smarty->assign('activeItem','telegrams');
        $this->smarty->assign('title', 'Настройки телеграм');

        $this->smarty->assign('statuses', array('V' => 'Включено', 'H' => 'Отключено'));

        $this->smarty->assign('logs', $telegram->logs);
        $this->smarty->assign('users', $telegram->users());

        /** setWebhook */
        if  ($this->action == 'set_webhook') {

            $timeout = !empty($telegram->setting['timeout']) ? $telegram->setting['timeout'] : '5';
            $result = $telegram->set_webhook($telegram->setting['telegram_key'], $timeout);

            if (!empty($result)) {
                response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();
            }
            exit;
        }
        /** clear log */
        else if ($this->action == 'clear_log') {
            $result = array();
            // Check user has permission
            if (!$this->request->has('key')) {
                $result['status'] = 400;
                $result['message'] = 'У вас нет прав для управления модулем ';
                $result['type'] = 'error';
            }

            if (!$result) {
                $key = $this->request->get('key');

                if ($key == 'telegram') {
                    $file = GLOBAL_ROOT . '/temp/log/telegram.log';
                } elseif ($key == 'viber') {
                    $file = GLOBAL_ROOT . '/temp/log/viber.log';
                } else {
                    $file = false;
                }

                if ($file) {
                    $handle = @fopen($file, 'w+');

                    fclose($handle);

                    $result['status'] = 200;
                    $result['message'] = 'Логи успешно очищены!';
                    $result['type'] = 'success';
                } else {
                    $result['status'] = 400;
                    $result['message'] = 'У вас нет прав для управления модулем';
                    $result['type'] = 'error';
                }
            }

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();
            exit;
        }

        /** download log */
        else if ($this->action == 'download_log') {
            $result = array();

            // Check user has permission
            if (!$this->request->has('key')) {
                $result['status'] = 400;
                $result['message'] = 'У вас нет прав для управления модулем ';
                $result['type'] = 'error';
            }

            if (!$result) {
                $key = $this->request->get('key');

                if ($key == 'telegram') {
                    $file = GLOBAL_ROOT . '/temp/log/telegram.log';
                } elseif ($key == 'viber') {
                    $file = GLOBAL_ROOT . '/temp/log/viber.log';
                } else {
                    $file = false;
                }

                if (file_exists($file) && filesize($file) > 0) {
                    $result['success'] = 'ok';
                } else {
                    $result['error'] = sprintf("Внимание: Ваш  файл ошибок %s имеет размер %s!", basename($file), '0B');
                }
            }

            if (isset($result['success'])) {
                response()->make(file_get_contents($file, FILE_USE_INCLUDE_PATH, null), \Mnv\Http\Response::HTTP_OK, [
                   'Pragma'                 =>  'public',
                   'Expires'                =>  '0',
                   'Content-Description'    =>  'File Transfer',
                   'Content-Type'           =>  'application/octet-stream',
                   'Content-Disposition'    =>  'attachment; filename="notifications_' . $key . '_error_' . date('Y-m-d_H-i-s', time()) . '.log"',
                   'Content-Transfer-Encoding' =>  'binary',
                ])->send();
            }

            if (!$result) {
                $result['error'] = sprintf("Внимание: Ваш  файл ошибок %s имеет размер %s!", basename($file), '0B');
            }

            if (!isset($result['success'])) {
                response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();
            }
            exit();
        }

        /** сохранение настроек */
        else if ($this->action == 'save') {

//            print_r($telegram->telegram_user_data);

            if (!empty($telegram->telegram_proxy_data)) {
                $telegram->setting['telegram_proxy_data'] = json_encode($telegram->telegram_proxy_data);
            }
            $telegram->setting['telegram_user_data'] = json_encode($telegram->telegram_user_data);

            foreach ($telegram->setting as $codename => $value) {

                $updateSetting['codename'] = $codename;
                $updateSetting['value'] = $value;

                $telegram->update($updateSetting);
            }
        }

        /**  получить обновленные настройки */
        $this->smarty->assign('logs_file', $telegram->readlogs('telegram.log'));
        $this->smarty->assign('telegram', $telegram->all());

        if ($this->permissions('telegrams')) {
            return $this->smarty->fetch('views/telegrams/index.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }


}