<!-- Page header -->
{capture name="buttons"}
{/capture}

{capture name="breadcrumb"}
	<a href="{$adminUrl}/errortexts" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url="{$adminUrl}/errortexts"}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->


<!-- Content area -->
<div class="content">

	<div class="row">
		<div class="col-md-12">
			<div class="card border shadow-sm">
				<div class="">
					<table class="table table-xs table-togglable table-striped table-hover" id="errortexts">
						<thead>
						<tr>
							<th class="text-start" data-width="30">{users:table:date}</th>
							<th class="">URL</th>
							<th>ТЕКСТ</th>
							<th class="text-center text-muted" data-width="30"><i class="ph-check"></i></th>
						</tr>
						</thead>
                        {if isset($feedbacks)}
							<tbody>
                            {foreach item=feedback from=$feedbacks name=feedbacks}
								<tr id="errortext-{$feedback.id}" data-id="{$feedback.id}">
									<td class="text-nowrap"><b>{$feedback.created}</b></td>
									<td class="text-left"><a href="{$feedback.url}" target="_blank">{$feedback.url}</a></td>
									<td class="text-left">{$feedback.text}</td>

									<td class="text-center">
										<div class="d-inline-flex">
											<button class="text-danger btn btn-link p-1" data-bs-popup="tooltip" title="{general:delete}" data-bs-placement="auto" onclick="newRemove('{$feedback.id}', '{$feedback.text|truncate:25}', 'errortexts');"><i class="ph-trash"></i></button>
										</div>
									</td>
								</tr>
                            {/foreach}

							</tbody>
                        {else}
							<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                        {/if}
					</table>
				</div>
                {include file="module/pagination.tpl" url="{$adminUrl}/errortexts" params="{$buildQueryString}"}
			</div>
		</div>

	</div>
</div>
