<form method="post" id="geo">

	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/countries"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/countries" class="breadcrumb-item">{$title}</a>
	    <span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}
    {/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

    <!-- Content area -->
    <div class="content">
        <div class="row"> 
            <div class="col-md-8">
    		    <div class="card border shadow-sm">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">{general:card:general}</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
	                    <div class="card-body">
	                        <div class="row">
	                            <div class="col-md-6">
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible {if isset($errors.name)}text-danger{/if}">{general:title}</label>
	                                    <input type="text" class="form-control" autocomplete="off" id="name" name="country[name]" value="{$country.name|default:""}">
	                                </div>
	                            </div>
		                        <div class="col-md-6">
			                        <div class="form-group mb-3">
				                        <label class="form-label is-visible {if isset($errors.fileName)}text-danger{/if}">На латинице</label>
				                        <input type="text" class="form-control" id="fileName" name="country[fileName]" value="{$country.fileName|default:""}">
			                        </div>
		                        </div>
{*					            <div class="col-md-6">*}
{*						            <div class="form-group mb-3">*}
{*							            <label class="form-label is-visible">Сумма доставки</label>*}
{*							            <input type="text" class="form-control" autocomplete="off" id="alias" name="country[price]" value="{$country.price|default:""}">*}
{*						            </div>*}
{*					            </div>*}
		                        <div class="col-md-6">
						            <div class="form-group mb-3">
							            <label class="form-label is-visible">Координаты</label>
							            <input type="text" class="form-control" autocomplete="off" id="alias" name="country[coordinates]" value="{$country.coordinates|default:""}">
						            </div>
					            </div>
	                        </div>
	                    </div>
			        </div>
    		    </div>
            </div>
    
            <div class="col-md-4">
        		<div class="card border shadow-sm">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">{general:card:statusAndVisibility}</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
	                    <div class="card-body">
                            {* field status *}
                            {include file="components/fields/select.tpl" id="status" title="{general:status}" field="country[status]" array=$statuses selected=$country.status|default:'visible'  class="form-group mb-3"}
                            {* /field status *}
	                    </div>
			        </div>
    				
    			</div>
            </div>

	        <div class="col-md-12 main main_buttons text-center">
                {if isset($country.id)}<input type="hidden" class="form-control" id="id" name="id" value="{$country.id|default:''}">{/if}
                {$smarty.capture.buttons nofilter}
	        </div>

        </div>
    </div>

</form>

<script>
    $(document).ready(function() {
        {if isset($errors.name)} new Noty({ text: 'Введите название страны', type: 'error'}).show(); {/if}
        {if isset($errors.fileName)}new Noty({ text: 'Введите код страны', type: 'error'}).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: 'Страна НЕ сохранена', type: 'error' }).show(); {/if}
        {if isset($messages.saved)} new Noty({ text: 'Страна сохранена', type: 'success' }).show(); {/if}
    });

    $(function () {
        function e() { fileName_touched || $("#fileName").val(n()) }
        function n() { return fileName = $("#name").val(), fileName = fileName.replace(/[\s]+/gi, "{$config.filename_word_separator}"), fileName = l(fileName), fileName = fileName.replace(/[^0-9a-z_\-]+/gi, "").toLowerCase() }
        function l(e) { for (var a = "А-а-Б-б-В-в-Ґ-ґ-Г-г-Д-д-Е-е-Ё-ё-Є-є-Ж-ж-З-з-И-и-І-і-Ї-ї-Й-й-К-к-Л-л-М-м-Н-н-О-о-П-п-Р-р-С-с-Т-т-У-у-Ф-ф-Х-х-Ц-ц-Ч-ч-Ш-ш-Щ-щ-Ъ-ъ-Ы-ы-Ь-ь-Э-э-Ю-ю-Я-я".split("-"), i = "A-a-B-b-V-v-G-g-G-g-D-d-E-e-E-e-E-e-ZH-zh-Z-z-I-i-I-i-I-i-J-j-K-k-L-l-M-m-N-n-O-o-P-p-R-r-S-s-T-t-U-u-F-f-H-h-TS-ts-CH-ch-SH-sh-SCH-sch-'-'-Y-y-'-'-E-e-YU-yu-YA-ya".split("-"), t = "", n = 0, l = e.length; l > n; n++) { var o = e.charAt(n),c = a.indexOf(o);t += c >= 0 ? i[c] : o } return t }
        fileName_touched = !0, ($("#fileName").val() == n() || "" == $("#fileName").val()) && (fileName_touched = !1), $("#fileName").change( function () { fileName_touched = !0 }), $("#name").keyup( function () { e() })
    });
            
</script>