<form method="post" enctype="multipart/form-data">
	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/features?page={if !empty($page)}{$page}{/if}{$buildQueryString}"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/features" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
		<span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

    <div class="content">

        <div class="row"> 
            <div class="col-md-12">
    
    		    <div class="card border shadow-sm">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">{general:card:general}</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
	                    <div class="card-body">
	                        <div class="row">
					            <div class="col-md-4">
                                    {* field status *}
                                    {include file="components/fields/select.tpl" id="status" title="{general:status}" field="feature[status]" array=$statuses selected=$feature.status|default:'visible' class="form-group mb-3"}
                                    {* /field status *}
					            </div>
		                        <div class="col-md-4">
						            <div class="form-group mb-3">
							            <label class="form-label animatу is-visible {if isset($errors.name)}text-danger{/if}">{general:title}</label>
							            <input type="text" class="form-control" id="name" autocomplete="off" name="feature[name]" value="{if isset($feature.name)}{$feature.name}{/if}">
						            </div>
					            </div>
					            <div class="col-md-4">
						            <div class="form-group mb-3">
							            <label class="form-label animatу is-visible {if isset($errors.fileName)}text-danger{/if}">Название свойства на анг</label>
							            <input type="text" class="form-control" id="fileName" name="feature[fileName]" value="{if isset($feature.fileName)}{$feature.fileName}{/if}">
						            </div>
					            </div>
	                            <div class="col-md-12">
	                                <div class="form-group">
	                                    <label class="form-label is-visible {if isset($errors.sectionId)}text-danger{/if}">{general:section}</label>
		                                <select class="form-control multiselect" name="feature[sectionIds][]" multiple="multiple" data-include-select-all-option="true" data-enable-filtering="true" data-enable-case-insensitive-filtering="true">
			                                {foreach from=$sections item=section key=key}
			                                <option value="{$key}" {if !empty($feature.sectionIds) && in_array($key, $feature.sectionIds)}selected{/if}>{$section}</option>
			                                {/foreach}

		                                </select>

{*	                                    {html_options options=$sections name="feature[sectionIds][]" selected=$feature.sectionIds|default:'' class="form-control multiselect" multiple="multiple" data-include-select-all-option="true"}*}
	                                </div>
	                            </div>

	                        </div>
	                    </div>
			        </div>
    		    </div>
                {* summary / content *}
	            <div class="card border shadow-sm">
		            <div class="card-header d-flex flex-wrap">
			            <h6 class="mb-0">{general:card:description}</h6>
			            <div class="d-inline-flex ms-auto">
				            <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
			            </div>
		            </div>
		            <div class="collapse show">
			            <div class="card-body flex-column flex-md-row m-0  p-0">
				            <textarea name="feature[content]" class="description">{if isset($feature.content)}{$feature.content}{/if}</textarea>
			            </div>
		            </div>
	            </div>
    

            
            </div>

	        <div class="col-md-12 main main_buttons text-center">
                {if isset($feature.id)}<input type="hidden" class="form-control" id="id" name="id" value="{$feature.id|default:''}">{/if}
                {$smarty.capture.buttons nofilter}
	        </div>

        </div>
    </div>
</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

<script>

    function notFound() {
        new Noty({ text: '{articles:errors:6}', layout: 'topRight', type: 'error', timeout: 1500 }).show();
    }
    function deleteImageSuccess(){
        new Noty({ text: '{articles:messages:1}', type: 'success', timeout: 1500 }).show();
        document.getElementById('image_general').style.display = 'none';
    }
    function deleteImageError(){
        new Noty({ text: '{sections:errors:14}', type: 'error', timeout: 2500 }).show();
    }
    function deleteMessage(){
        new Noty({ text: '{articles:messages:2}', type: 'success', timeout: 1500 }).show();
    }
    function successImageMessage(){
        new Noty({ text: '{sections:messages:10}', type: 'success', timeout: 1500 }).show();
    }

    function successSortImageMessage(){
        new Noty({ text: 'Порядковый номер изменен', type: 'success', timeout: 1500 }).show();
    }

    $(document).ready(function () {
        {if isset($messages.saved)} new Noty({ text: 'Свойство "{if isset($feature.name)}{$feature.name}{/if}" сохранено', type: 'success', timeout: 1500 }).show(); {/if}

        {if isset($errors.name)} new Noty({ text: 'Введите название свойства', type: 'error', timeout: 2500 }).show();{/if}
        {if isset($errors.sectionId)} new Noty({ text: 'Необходимо указать раздел(ы) ', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: 'Свойство "{if isset($feature.name)}{$feature.name}{/if}" не сохранено', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: '{articles:errors:4}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.fileName)} new Noty({ text: 'Введите название свойства на анг. языке', type: 'error', timeout: 2500 }).show(); {/if}
    });

</script>
