
<form method="post" enctype="multipart/form-data">

	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/products?page={if !empty($page)}{$page}{/if}{$buildQueryString}"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/products" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
		<span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->


	<!-- Content area -->
	<div class="content">

		<div class="row">
			<div class="col-md-8">
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:general}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">

							<div class="row">
								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label is-visible {if isset($errors.sectionId)}text-danger{/if}">{general:section} <span class="text-danger">*</span></label>
                                        {html_options options=$sections name="product[sectionId]" id="sectionId" selected=$product.sectionId|default:0 class="form-control select-search"}
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label is-visible {if isset($errors.title)}text-danger{/if}">{products:general:title} <span class="text-danger">*</span></label>
										<input type="text" class="form-control" id="title" autocomplete="off" name="product[title]" value="{$product.title|default:''}" onblur="proposeFileName('title', 'fileName', 'article', '{$config.filename_word_separator}', '{$config.convert_filename_to_lowercase}');">
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label is-visible">{general:alias}</label>
										<input class="form-control" autocomplete="off" id="alias" type="text" name="product[alias]" value="{$product.alias|default:''}" />
									</div>
								</div>
{*								<div class="col-md-6">*}
{*									<div class="form-group mb-3">*}
{*										<label class="form-label is-visible">Артикул</label>*}
{*										<input type="text" class="form-control" id="sku" autocomplete="off" name="product[sku]" value="{$product.sku|default:""}">*}
{*									</div>*}
{*								</div>*}
{*								<div class="col-md-6">*}
{*									<div class="form-group mb-3">*}
{*										<label class="form-label is-visible">Универсальный код товара</label>*}
{*										<input type="text" class="form-control" id="ikpu" autocomplete="off" name="product[ikpu]" value="{$product.ikpu|default:""}">*}
{*									</div>*}
{*								</div>*}

{*								<div class="col-md-6">*}
{*									<div class="form-group mb-3">*}
{*										<label class="form-label is-visible {if isset($errors.price)}text-danger{/if}">Цена <span class="text-danger">*</span></label>*}
{*										<input type="text" class="form-control" id="price" autocomplete="off" name="product[price]" value="{$product.price|default:"0.00"}">*}
{*									</div>*}
{*								</div>*}

{*								<div class="col-md-6">*}
{*									<div class="form-group mb-3">*}
{*										<label class="form-label is-visible">Старая цена</label>*}
{*										<input type="text" class="form-control" id="oldPrice" autocomplete="off" name="product[old_price]" value="{$product.old_price|default:"0.00"}">*}
{*									</div>*}
{*								</div>*}


{*								<div class="col-md-4">*}
{*									<div class="form-group mb-3">*}
{*										<label class="form-label is-visible {if isset($errors.quantity)}text-danger{/if}">Количество <span class="text-danger">*</span></label>*}
{*										<input type="text" class="form-control" id="quantity" autocomplete="off" name="product[quantity]" value="{$product.quantity|default:""}">*}
{*									</div>*}
{*								</div>*}
{*								<div class="col-md-4">*}
{*	                                *}{* field status *}
{*	                                {include file="components/fields/select.tpl" id="subtracts" title="Вычитать со склада" field="product[subtract]" array=$subtracts selected=$product.subtract|default:'N'  class="form-group mb-3"}*}
{*	                                *}{* /field status *}
{*								</div>*}
{*								<div class="col-md-4">*}
{*	                                *}{* field status *}
{*	                                {include file="components/fields/select.tpl" id="stock_status" title="Отсутствие на складе" field="product[stock_status_id]" array=$stock_status selected=$product.stock_status_id|default:''  class="form-group mb-3"}*}
{*	                                *}{* /field status *}
{*								</div>*}
{*								<div class="col-md-4">*}
{*									<div class="form-group mb-3">*}
{*										<label class="form-label is-visible">Необходима доставка</label>*}
{*										<input type="text" class="form-control" id="oldPrice" autocomplete="off" name="product[shipping]" value="{$product.shipping}">*}
{*									</div>*}
{*								</div>*}

								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label is-visible {if isset($errors.fileName) || isset($errors.fileNameExists) || isset($errors.fileNameProhibited) || isset($errors.fileNameCharacters)}text-danger{/if}">{general:filename}</label>
										<input  type="text" class="form-control" id="fileName" autocomplete="off" name="product[fileName]" value="{$product.fileName|default:''}" />
									</div>
								</div>

							</div>
						</div>
					</div>
				</div>

{*				<div class="card border shadow-sm" id="tab-option">*}
{*					<div class="card-header d-flex flex-wrap">*}
{*						<h6 class="mb-0">Опции</h6>*}
{*						<div class="d-inline-flex ms-auto">*}
{*							<input type="text" name="option" value="" placeholder="Опция" id="input-option" class="form-control"/>*}
{*						</div>*}
{*					</div>*}
{*					<div class="collapse show">*}
{*						<div class="card-body p-0">*}

{*							<ul class="nav nav-tabs nav-tabs-underline" id="option_ul">*}
{*                                {if isset($product.product_options)}*}
{*                                    {foreach from=$product.product_options item=product_option name=product_options key=key}*}
{*										<li class="nav-item">*}
{*											<a href="#tab-option{$key}" class="nav-link {if $smarty.foreach.product_options.first}active{/if}" data-bs-toggle="tab">{$product_option.name}<span class="nav-btn-close rounded-1 ms-3 me-1"><i class="ph-x ph-sm" onclick="$('#option_ul a:first').tab('show'); $('a[href=\'#tab-option{$key}\']').parent().remove(); $('#tab-option{$key}').remove();"></i></span></a>*}
{*										</li>*}
{*                                    {/foreach}*}
{*                                {/if}*}
{*								<li class="text-end">*}{*<input type="text" name="option" value="" placeholder="Опция" id="input-option" class="form-control"/>*}{*</li>*}
{*							</ul>*}

{*							<div class="tab-content tab-content-options">*}
{*                                {assign var=option_row value=0}*}
{*                                {assign var=option_value_row value=0}*}
{*                                {if isset($product.product_options)}*}
{*                                {foreach from=$product.product_options item=product_option name=product_options}*}
{*									<div class="tab-pane fade {if $smarty.foreach.product_options.first}active show{/if}" id="tab-option{$option_row}">*}
{*										<input type="hidden" name="product_option[{$option_row}][product_option_id]" value="{$product_option.product_option_id}"/>*}
{*										<input type="hidden" name="product_option[{$option_row}][name]" value="{$product_option.name}"/>*}
{*										<input type="hidden" name="product_option[{$option_row}][option_id]" value="{$product_option.option_id}"/>*}
{*										<input type="hidden" name="product_option[{$option_row}][type]" value="{$product_option.type}"/>*}

{*										<div class="row my-3">*}
{*											<label class="col-lg-3 col-form-label text-lg-end" for="input-required{$option_row}">Необходимо</label>*}
{*											<div class="col-lg-8">*}
{*												<select name="product_option[{$option_row}][required]" id="input-required{$option_row}" class="form-control select">*}
{*													<option value="1" {if $product_option.required eq 1}selected="selected"{/if}>Да</option>*}
{*													<option value="0" {if $product_option.required eq 0}selected="selected"{/if}>Нет</option>*}
{*												</select>*}
{*											</div>*}
{*										</div>*}

{*                                        {if $product_option.type == 'text'}*}
{*											<div class="form-group">*}
{*												<label class="col-sm-2 control-label" for="input-value{$option_row}">Значение опции</label>*}
{*												<div class="col-sm-10">*}
{*													<input type="text" name="product_option[{$key}][value]" value="{$product_option.value}" placeholder="Значение опции" id="input-value{$option_row}" class="form-control"/>*}
{*												</div>*}
{*											</div>*}
{*                                        {/if}*}
{*                                        {if $product_option.type == 'textarea'}*}
{*											<div class="form-group">*}
{*												<label class="col-sm-2 control-label" for="input-value{$option_row}">Значение опции</label>*}
{*												<div class="col-sm-10">*}
{*													<textarea name="product_option[{$option_row}][value]" rows="5" placeholder="Значение опции" id="input-value{$option_row}" class="form-control">{$product_option.value}</textarea>*}
{*												</div>*}
{*											</div>*}
{*                                        {/if}*}
{*                                        {if $product_option.type == 'file'}*}
{*											<div class="form-group" style="display: none;">*}
{*												<label class="col-sm-2 control-label" for="input-value{$option_row}">Значение опции</label>*}
{*												<div class="col-sm-10">*}
{*													<input type="text" name="product_option[{$option_row}][value]" value="{$product_option.value}" placeholder="Значение опции" id="input-value{$option_row}" class="form-control"/>*}
{*												</div>*}
{*											</div>*}
{*                                        {/if}*}
{*                                        {if $product_option.type == 'date'}*}
{*											<div class="form-group">*}
{*												<label class="col-sm-2 control-label" for="input-value{$option_row}">Значение опции</label>*}
{*												<div class="col-sm-3">*}
{*													<div class="input-group date">*}
{*														<input type="text" name="product_option[{$option_row}][value]" value="{$product_option.value}" placeholder="Значение опции" data-date-format="YYYY-MM-DD" id="input-value{$option_row}" class="form-control"/>*}
{*														<span class="input-group-btn"><button class="btn btn-default" type="button"><i class="fa fa-calendar"></i></button></span>*}
{*													</div>*}
{*												</div>*}
{*											</div>*}
{*                                        {/if}*}
{*                                        {if $product_option.type == 'time'}*}
{*											<div class="form-group">*}
{*												<label class="col-sm-2 control-label" for="input-value{$option_row}">Значение опции</label>*}
{*												<div class="col-sm-10">*}
{*													<div class="input-group time">*}
{*														<input type="text" name="product_option[{$option_row}][value]" value="{$product_option.value}" placeholder="Значение опции" data-date-format="HH:mm" id="input-value{$option_row}" class="form-control"/>*}
{*														<span class="input-group-btn"><button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button></span>*}
{*													</div>*}
{*												</div>*}
{*											</div>*}
{*                                        {/if}*}
{*                                        {if $product_option.type == 'datetime'}*}
{*											<div class="form-group">*}
{*												<label class="col-sm-2 control-label" for="input-value{$option_row}">Значение опции</label>*}
{*												<div class="col-sm-10">*}
{*													<div class="input-group datetime">*}
{*														<input type="text" name="product_option[{$option_row}][value]" value="{$product_option.value}" placeholder="Значение опции" data-date-format="YYYY-MM-DD HH:mm" id="input-value{$option_row}" class="form-control"/>*}
{*														<span class="input-group-btn"><button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button></span>*}
{*													</div>*}
{*												</div>*}
{*											</div>*}
{*                                        {/if}*}
{*                                        {if $product_option.type == 'select' or $product_option.type == 'radio' or $product_option.type == 'checkbox' or $product_option.type == 'image'}*}
{*											<div class="table-responsive">*}
{*												<table id="option-value{$option_row}" class="table table-xs table-striped table-bordered table-hover">*}
{*													<thead>*}
{*														<tr>*}
{*															<td class="text-start text-nowrap">Значение опции</td>*}
{*															<td class="text-end text-nowrap">Кол-во</td>*}
{*															<td class="text-start text-nowrap">Вычитать со склада</td>*}
{*															<td class="text-end text-nowrap">Цена</td>*}
{*															<td class="text-end text-nowrap">Вес</td>*}
{*	*}{*														<td class="text-end text-nowrap">Баллы</td>*}
{*															<td width="30"></td>*}
{*														</tr>*}
{*													</thead>*}
{*													<tbody>*}


{*                                                    {foreach from=$product_option.product_option_value item=product_option_value}*}
{*														<tr id="option-value-row{$option_value_row}">*}
{*															<td class="text-left">*}
{*																<select name="product_option[{$option_row}][product_option_value][{$option_value_row}][option_value_id]" class="form-control select"  data-width="200">*}
{*                                                                    {if $product.option_values[$product_option.option_id]}*}
{*                                                                        {foreach from=$product.option_values[$product_option.option_id] item=option_value}*}
{*                                                                            {if $option_value.option_value_id == $product_option_value.option_value_id}*}
{*																				<option value="{$option_value.option_value_id}" selected="selected">{$option_value.name}</option>*}
{*                                                                            {else}*}
{*																				<option value="{$option_value.option_value_id}">{$option_value.name}</option>*}
{*                                                                            {/if}*}
{*                                                                        {/foreach}*}
{*                                                                    {/if}*}
{*																</select>*}
{*																<input type="hidden" name="product_option[{$option_row}][product_option_value][{$option_value_row}][product_option_value_id]" value="{$product_option_value.product_option_value_id}"/>*}
{*															</td>*}
{*															<td class="text-right">*}
{*																<input type="number" name="product_option[{$option_row}][product_option_value][{$option_value_row}][quantity]" value="{$product_option_value.quantity}" placeholder="Кол-во" class="form-control" min="0"/>*}
{*															</td>*}
{*															<td class="text-left">*}
{*																<select name="product_option[{$option_row}][product_option_value][{$option_value_row}][subtract]" class="form-control select" data-width="150">*}
{*																	<option value="1" {if $product_option_value.subtract eq 1}selected="selected"{/if}>Да</option>*}
{*																	<option value="0" {if $product_option_value.subtract eq 0}selected="selected"{/if}>Нет</option>*}
{*																</select>*}
{*															</td>*}
{*															<td class="text-right">*}
{*															<select name="product_option[{$option_row}][product_option_value][{$option_value_row}][price_prefix]" class="form-control select">*}
{*																<option value="+" {if $product_option_value.price_prefix == '+'}selected="selected"{/if}>+</option>*}
{*																<option value="-" {if $product_option_value.price_prefix == '-'}selected="selected"{/if}>-</option>*}
{*															</select>*}
{*																<input type="text" name="product_option[{$option_row}][product_option_value][{$option_value_row}][price]" value="{$product_option_value.price}" placeholder="Цена" class="form-control"/>*}
{*															</td>*}
{*															<td class="text-right">*}
{*																<select name="product_option[{$option_row}][product_option_value][{$option_value_row}][weight_prefix]" class="form-control select">*}
{*																	<option value="+" {if $product_option_value.weight_prefix == '+'}selected="selected"{/if}>+</option>*}
{*																	<option value="-" {if $product_option_value.weight_prefix == '-'}selected="selected"{/if}>-</option>*}
{*																</select>*}
{*																<input type="text" name="product_option[{$option_row}][product_option_value][{$option_value_row}][weight]" value="{$product_option_value.weight}" placeholder="Вес" class="form-control"/>*}
{*															</td>*}
{*														<td class="text-right">*}
{*															<select name="product_option[{$option_row}][product_option_value][{$option_value_row}][points_prefix]" class="form-control">*}
{*																<option value="+" {if $product_option_value.points_prefix == '+'}selected="selected"{/if}>+</option>*}
{*																<option value="-" {if $product_option_value.points_prefix == '-'}selected="selected" {/if}>-</option>*}
{*															</select>*}
{*															<input type="text" name="product_option[{$option_row}][product_option_value][{$option_value_row}][points]" value="{$product_option_value.points}" placeholder="Баллы" class="form-control"/>*}
{*														</td>*}


{*															<td class="text-right">*}
{*																<button type="button" onclick="$('#option-value-row{$option_value_row}').remove();" class="btn btn-sm btn-danger"><i class="ph-trash"></i></button>*}
{*															</td>*}
{*														</tr>*}
{*                                                        {assign var=option_value_row value=$option_value_row + 1}*}
{*                                                    {/foreach}*}
{*													</tbody>*}

{*													<tfoot>*}
{*													<tr>*}
{*														<td colspan="5"></td>*}
{*														<td class="text-left"><button type="button" onclick="addOptionValue('{$option_row}');" data-bs-toggle="tooltip" title="Добавить" class="btn btn-sm btn-primary"><i class="ph-plus"></i></button></td>*}
{*													</tr>*}
{*													</tfoot>*}
{*												</table>*}
{*											</div>*}

{*											<select id="option-values{$option_row}" style="display: none;">*}
{*                                                {if $product.option_values[$product_option.option_id]}*}
{*                                                    {foreach from=$product.option_values[$product_option.option_id] item=option_value}*}
{*														<option value="{$option_value.option_value_id }">{$option_value.name}</option>*}
{*                                                    {/foreach}*}
{*                                                {/if}*}
{*											</select>*}
{*                                        {/if}*}
{*									</div>*}

{*                                    {assign var=option_row value=$option_row+1}*}
{*                                {/foreach}*}
{*								{/if}*}

{*							</div>*}
{*						</div>*}
{*					</div>*}
{*				</div>*}


                {* Цвета продукта *}
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">Цвета продукта</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body p-0">
							<table class="table table-xs colors" id="colors">
								<thead id="header">
								<tr>
									<th class="text-center w-24px">#</th>
									<th class="text-start">Название цвета</th>
									<th class="text-start">Статус</th>
									<th class="text-center">Картинка</th>
									<th class="text-center">Загрузить</th>
									<th class="text-center" width="30"><i class="ph-check"></i></th>
								</tr>
								</thead>

								<tbody class="sortable_icolor">
                                {if isset($product.colors)}
                                    {foreach from=$product.colors item=color key=key}
										<tr id="color-{$key}" data-id="{$color.imageId}">
											<td class="text-center text-nowrap p-0 w-24px"><i class="ph-dots-six text-muted"></i></td>
											<td class="text-start text-nowrap">
												<select name="colors[{$key}][colorId]" class="form-control select" data-width="200">
													<option value="0">Выбрать цвет...</option>
                                                    {foreach from=$product_colors item=ic}
														<option value="{$ic.colorId}" {if isset($color.colorId) AND $color.colorId eq $ic.colorId}selected{/if}>{$ic.colorName}</option>
                                                    {/foreach}
												</select>
											</td>
											<td class="text-start text-nowrap">
                                                {html_options options=$statuses selected=$color.status|default:'' name="colors[{$key}][status]" class="form-control select" data-width="200"}
											</td>
											<td class="text-center text-nowrap">
												<div class="preview preview-md"><img src="{$color.medium|default:"/admin/assets/img/no_images.jpg"}" class="img-thumbnail w-80px"/></div>
											</td>
											<td class="text-center text-nowrap">
												<button type="button" class="btn btn-sm btn-primary btn-upload read-more" data-type="colors" data-path="/" data-action="read_more" data-module="files" data-color="{$key}"><i class="ph-image me-2"></i>Заменить</button>
											</td>
											<td>
												<input type="hidden" name="colors[{$key}][imageId]" value="{$color.imageId}">
												<input class="file_id" type="hidden" name="colors[{$key}][fileId]" value="{$color.fileId}">
												<button type="button" class="btn btn-link text-danger p-0" onclick="confirm('Данное действие необратимо. Вы уверены?') ? deleteProductColor({$color.imageId}, 'product', {$key}): false;"><i class="ph-trash"></i></button>
											</td>
										</tr>
                                    {/foreach}
                                {/if}
								</tbody>
							</table>
						</div>
						<div class="card-footer d-sm-flex justify-content-sm-between align-items-sm-center">
							<button type="button" class="btn btn-outline-primary" onclick="addColors();">Добавить цвет</button>
							<button type="button" class="btn btn-sm btn-primary btn-sorting-color collapse"><i class="ph-check me-2"></i>{general:apply}</button>
						</div>
					</div>
				</div>

                {* Gallery *}
				<div class="collapse {if isset($product.enableGallery) and $product.enableGallery eq 1}show{/if}" id="gallery-card">
					<div class="card border shadow-sm">
						<div class="card-header d-flex flex-wrap">
							<h6 class="mb-0">{general:card:imageLibrary}</h6>
							<div class="d-inline-flex ms-auto">
								<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
							</div>
						</div>
						<div class="collapse show">
							<div class="card-body">
								<div class="row gallery gallery-product gallery-sortable mt-2 sortable" id="fileList">
	                                {if isset($product.gallery)}
	                                    {foreach item=file from=$product.gallery}
											<figure class="gallery-item mb-0" id="gallery-item-{$file.imageId}" data-id="{$file.imageId}">
												<div class="move_zone image">
													<img src="{$file.medium}" alt="{$file.title|default:''}"/>
													<ul class="gallery-item-controls">
														<li><span>{$file.orderBy}</span></li>
														<li>
		                                                   <span class="edit_image" id="edit_image_{$file.imageId}"
		                                                         data-title="{$file.title}"
		                                                         data-alias="{$file.alias}"
		                                                         data-description="{$file.description}"
		                                                         data-link="{$file.link}"
		                                                         data-position="{$file.position}"
		                                                         onclick="editPictureInfo({$file.imageId}, 'Добавить описание к картинке', 'product');"><i class="ph-note-pencil"></i>
		                                                   </span>
														</li>
														<li>
															<span onclick="deletePicture({$file.imageId}, 'product');"><i class="ph-trash"></i></span>
														</li>
													</ul>
												</div>
												<div class="meta" id="meta_image_{$file.imageId}">
													<span id="im_title" class="fs-sm fw-normal fw-semibold">{$file.title}</span>
													<span id="im_alias" class="fs-sm fw-normal">{$file.alias}</span>
													<span id="im_description" class="fs-sm fw-normal">{$file.description nofilter}</span>
													<span id="im_link" class="fs-sm fw-normal">{$file.link}</span>
													<span id="im_position" class="badge bg-primary text-white fs-sm fw-light">{$file.position}</span>
												</div>
											</figure>
	                                    {/foreach}
	                                {/if}
								</div>
							</div>
							<div class="card-footer d-sm-flex justify-content-sm-between align-items-sm-center">
								<button class="btn btn-sm btn-primary btn-upload read-more"
								        data-type="gallery"
								        data-path="/"
								        data-action="read_more"
								><i class="ph-image me-2"></i> {general:uploadFiles} </button>
								<button class="btn btn-sm btn-primary btn-sorting collapse" data-action="sortPictures" data-module="product"><i class="icon-checkmark3 me-2"></i> {general:apply}</button>
							</div>
						</div>
					</div>
				</div>

                {* summary / content *}
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:description}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body flex-column flex-md-row m-0  p-0">
							<ul class="nav nav-tabs nav-tabs-overline border-top-0 mb-0">
								<li class="nav-item"><a href="#summary" class="nav-link active show" data-bs-toggle="tab">{general:tabs:summary}</a></li>
								<li class="nav-item"><a href="#content" class="nav-link" data-bs-toggle="tab">{general:tabs:content}</a></li>
							</ul>

							<div class="tab-content border-top-0 rounded-top-0 mb-0">
								<div class="tab-pane fade show active" id="summary">
									<textarea name="product[summary]" class="description">{if isset($product.summary)}{$product.summary}{/if}</textarea>
								</div>

								<div class="tab-pane fade" id="content">
									<textarea name="product[content]" class="description">{if isset($product.content)}{$product.content}{/if}</textarea>
								</div>
							</div>
						</div>
					</div>
				</div>


                {* Характеристики товара *}
				<div id="features_card" class="collapse {if !empty($features)}show{/if}">
					<div class="card border shadow-sm">
						<div class="card-header d-flex flex-wrap">
							<h6 class="mb-0">Свойства продукта</h6>
							<div class="d-inline-flex ms-auto">
								<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
							</div>
						</div>
						<div class="collapse show">
							<div class="card-body">
								<ul class="features-list list-style media-list p-0 mb-0">
                                    {if !empty($features)}
                                        {foreach $features as $feature}
											<li class="d-flex p-2 media feature" data-feature={$feature.id}>
												<label class="col-4 mb-0 me-auto">{$feature.name}</label>
												<div class="col-8">
													<div class=" input-group">
														<input class="form-control" type="text" name="feature_values[{$feature.id}]" value="{if isset($feature_values[$feature.id]) && !empty($feature_values)}{$feature_values[$feature.id].value}{/if}" autocomplete="off" placeholder=""/>
													</div>
												</div>
											</li>
                                        {/foreach}
                                    {/if}
								</ul>

                                {* Новые свойства *}
								<ul class="new_features list-style media-list p-0 mb-0">
									<li id="new_feature" class="d-flex p-2 media">
										<div class="col-4 mb-0 me-auto">
											<label class="property"><input class="form-control" type=text name=new_features_names[]></label>
										</div>
										<div class="col-8">
											<div class=" input-group">
												<input class="form-control" type="text" name=new_features_values[]/>
{*												<input class="form-control" type="text" name=new_features_icons[]/>*}
											</div>
										</div>

									</li>
								</ul>
							</div>
							<div class="card-footer text-right">
								<button id="add_new_feature" type="button" class="btn btn-outline-primary add">Добавить новое свойство</button>
							</div>
						</div>
					</div>
				</div>

			</div>


			<div class="col-md-4">
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:statusAndVisibility}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body border-top-0">
                            {* field status *}
                            {include file="components/fields/select.tpl" id="status" title="{general:status}" field="product[status]" array=$statuses selected=$product.status|default:'visible'  class="form-group mb-3"}
                            {* /field status *}

							<div class="form-group mb-3">
								<label class="form-label is-visible">{general:misc:publishDate}</label>
								<div class="input-group">
									<span class="input-group-text"><i class="ph-calendar"></i></span>
									<input type="text" class="form-control date-range-single" name="product[publishedOn]" value="{$product.publishedOn|default:$adjustedNow}" readonly />
								</div>
							</div>

							<div class="form-check mb-3">
								<input type="checkbox" class="form-check-input" id="enableGallery" name="product[enableGallery]" value="1"
                                       {if isset($product.enableGallery) and $product.enableGallery eq 1}checked{/if}
								       data-bs-toggle="collapse"
								       data-bs-target="#gallery-card"
								       aria-expanded="{if isset($product.enableGallery) and $product.enableGallery eq 1}true{else}false{/if}">
								<label class="form-check-label" for="enableGallery">Фотогалерея к этой публикации</label>
							</div>

                            {* field status *}
{*                            {include file="components/fields/select.tpl" id="subtracts" title="Вычитать со склада" field="product[subtract]" array=$subtracts selected=$product.subtract|default:'N'  class="form-group mb-3"}*}
                            {* /field status *}

                            {* field status *}
{*                            {include file="components/fields/select.tpl" id="stock_status" title="Отсутствие на складе" field="product[stock_status_id]" array=$stock_status selected=$product.stock_status_id|default:''  class="form-group mb-3"}*}
                            {* /field status *}

							{* field status *}
                            {include file="components/fields/select.tpl" id="specials" title="Особенность" field="product[special]" array=$specials selected=$product.special|default:''  class="form-group mb-3"}
                            {* /field status *}


							<div class="form-group mb-3">
								<label class="form-label is-visible">{general:misc:featured}</label>
								<select name="product[isFeatured]" class="form-control select">
									<option value="0" {if isset($product.isFeatured) and $product.isFeatured eq 0} selected{/if}>{general:no}</option>
									<option value="1" {if isset($product.isFeatured) and $product.isFeatured eq 1} selected{/if}>{general:yes}</option>
								</select>
							</div>
							<div class="form-group">
								<label class="form-label is-visible">{general:misc:comments}</label>
								<select name="product[commentsEnabled]" class="form-control select">
									<option value="0" {if isset($product.commentsEnabled) and $product.commentsEnabled == 0} selected{/if}>{general:defaultComments}</option>
									<option value="-1" {if isset($product.commentsEnabled) and $product.commentsEnabled == -1} selected{/if}>{general:disableComments}</option>
									<option value="1" {if isset($product.commentsEnabled) and $product.commentsEnabled == 1} selected{/if}>{general:enableComments}</option>
								</select>
							</div>

						</div>

						<div class="card-footer hstack gap-3 justify-content-between">
							<div class="text-muted">
								<ul class="list list-unstyled mb-0 fs-sm">
                                    {if isset($product.addedOn)}<li>{general:created}</li>{/if}
                                    {if isset($product.modifiedOn)}<li>{general:modified}</li>{/if}
								</ul>
							</div>
							<div class="hstack gap-1">
								<ul class="list list-unstyled mb-0 fs-sm">
                                    {if isset($product.addedOn)}<li>{$product.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$product.addedBy.loginName|default:"{general:unknownUser}"})</li>{/if}
                                    {if isset($product.modifiedOn)} <li>{$product.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$product.modifiedBy.loginName|default:"{general:unknownUser}"})</li>{/if}
								</ul>
							</div>
						</div>
					</div>
				</div>

                {* image preview *}
                {include file="components/image-preview.tpl"
                image="{if isset($product.image)}{$product.image.original}{/if}"
                id="{if isset($product.image)}{$product.image.imageId}{/if}"
                module='product'}
                {* /image preview *}


				<div class="card">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:rating}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div>
								<p class="mb-3 text-muted">Значение рейтинга: <code class="font-weight-semibold" id="noui-stepping-val"></code> </p>
							</div>
							<div class="noui-height-helper" id="noui-slider-snap"></div>
							<input type="hidden" class="form-control ion-height-helper" id="noui-rating" name="product[rating]" value="{if !empty($product.rating)}{$product.rating}{/if}">

							<div class="form-group mt-3">
								<label class="form-label is-visible">Количество голосов:</label>
								<input class="form-control" autocomplete="off" id="votes" type="text" name="product[votes]" value="{if isset($product.votes)}{$product.votes}{/if}"/>
							</div>
						</div>
					</div>
				</div>


				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:seo}</h6>
						<div class="d-inline-flex ms-auto">
{*							<button type="button" class="btn btn-link" onclick="auto_keywords();">Сгенерировать ключевые слова</button>*}
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body flex-column flex-md-row m-0">
							<div class="form-group mb-3">
								<label class="form-label is-visible">{general:keywords}</label>
								<div class="input-group">
									<input type="text" class="form-control tokenfield-primary" id="keywords" name="product[keywords]" value="{if isset($product.keywords)}{$product.keywords}{/if}" data-fouc>
								</div>
							</div>
							<div class="form-group mb-3">
								<label class="form-label is-visible">{general:description}</label>
								<textarea id="description" name="product[description]" class="form-control" rows="3">{if isset($product.description)}{$product.description}{/if}</textarea>
							</div>
						</div>
					</div>
				</div>

			</div>

			<div class="col-md-12 text-center">
                {if isset($product.productId)}<input type="hidden" class="form-control" id="id" name="id" value="{$product.productId}">{/if}
                {$smarty.capture.buttons nofilter}
			</div>

		</div>

	</div>

</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>

    $(document).ready(function () {

        {if isset($errors.access_denied)}       new Noty({ text: '{products:errors:0}',  type: 'error', timeout: 1500 }).show();     {/if}
        {if isset($errors.title)}               new Noty({ text: '{products:errors:1}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.brand)}               new Noty({ text: 'Необходимо указать бренд продукта',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.sectionId)}           new Noty({ text: '{products:errors:2}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.not_saved)}           new Noty({ text: '{products:errors:3}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.no_sections)}         new Noty({ text: '{products:errors:4}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.image_not_saved)}     new Noty({ text: '{products:errors:5}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.article_not_found)}   new Noty({ text: '{products:errors:6}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.fileName)}            new Noty({ text: '{products:errors:7}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.fileNameExists)}      new Noty({ text: '{products:errors:8}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.fileNameProhibited)}  new Noty({ text: '{products:errors:11}', type: 'error', timeout: 2500 }).show();    {/if}
        {if isset($errors.fileNameCharacters)}  new Noty({ text: '{products:errors:12}', type: 'error', timeout: 2500 }).show();    {/if}
        {if isset($errors.htaccess)}            new Noty({ text: '{products:errors:9}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.serializations)}      new Noty({ text: '{products:errors:10}', type: 'error', timeout: 1500 }).show();    {/if}

        {if isset($messages.saved)}             new Noty({ text: '{products:messages:0}', type: 'success', timeout: 1500 }).show();  {/if}
    });

    // rating
    const productId = '{$product.productId|default:''}';
    const ratingValue = '{$product.rating|default:0}';

    const sliderStepping = document.getElementById('noui-slider-snap');
    noUiSlider.create(sliderStepping, { start: [ratingValue], step: 1, range: { 'min': [0], 'max': [5] } });
    const sliderSteppingVal = document.getElementById('noui-stepping-val');
    sliderStepping.noUiSlider.on('update', function( values, handle ) {
        sliderSteppingVal.innerHTML = values[handle];
        document.getElementById('noui-rating').value  = values[handle];
    });

    // сортировать фотогалерею
    $(document).on('click', '.sortable_save_button', function () {
        var ids = new Array();
        $('#fileList figure.gallery-item').each(function () {
            console.log($(this).attr('data-id'))

            ids.push($(this).attr('data-id'));
        })
        $.post( "{$adminUrl}/product?action=sortPictures", { imageIds : ids }, function() {
            $('.sortable_footer_navbar').removeClass('show');
            $("#fileList").load(location.href + " figure.gallery-item");
            new Noty({ text: 'Фотогалерея отсортирована', type: 'success' }).show();
        });
    })
    $(document).on('click', '.sortable_cancel_button', function () {
        $('.sortable_footer_navbar').removeClass('show');
        $("#fileList").load(location.href + " figure.gallery-item");
    })


    // цвета салона
    {if empty($product.colors)}
	    $(document).ready(function() {
	        addColors();
	    });
	    var color_row = 0;
    {else}
	    var color_row = {count($product.colors)};
	    dragula(Array.from(document.querySelectorAll('.sortable_icolor')), {
	        direction: 'vertical',
	        slideFactorY: 100,
	        mirrorContainer: document.querySelector('.sortable_icolor')
	    }).on('drop', function (el) {
	        $('.btn-sorting-color').addClass('show');
	    });

    {/if}

    function addColors() {
        html  = '<tr id="color-' + color_row + '">';
        html += '<td class="text-center text-nowrap p-0 w-24px"><i class="ph-dots-six text-muted"></i></td>';
        html += '<td class="text-start text-nowrap">' +
                '<select name="colors[' + color_row + '][colorId]" class="form-control select" data-width="200">' +
                    '<option value="0">Выбрать цвет...</option>';
                        {foreach from=$product_colors item=ic}
        html +=         '<option value="{$ic.colorId}">{$ic.colorName}</option>';
                        {/foreach}
        html +=      '</select>';
        html += '</td>';
        html += '<td><select name="colors[' + color_row + '][status]" class="form-control select" data-width="200"><option value="V" selected="selected">Включено</option><option value="H">Скрыто</option></select></td>';
        //html += '<td class="text-center text-nowrap"><input type="text" name="colors[' + color_row + '][price]" value="" placeholder="Цена" class="form-control" /></td>';
        html += '<td class="text-center text-nowrap"><div class="preview preview-md"><img src="/admin/assets/img/no_images.jpg" class="img-thumbnail w-80px"/></div></td>';
        html += '<td class="text-center text-nowrap"><button type="button" class="btn btn-sm btn-primary btn-upload read-more" data-type="colors" data-path="/" data-action="read_more" data-module="files" data-color="' + color_row + '"><i class="ph-image me-2"></i>Добавить</button></td>';
        html += '<td>' +
            '<input class="file_id" type="hidden" name="colors[' + color_row + '][fileId]" value="">' +
            '<button type="button" class="btn btn-link text-danger p-0" onclick="confirm(\'Данное действие необратимо. Вы уверены?\') ? $(\'#color-' + color_row + '\').remove() : false;"><i class="ph-trash"></i></button>' +
            '</td>';
        html += '</tr>';

        $('.colors tbody').append(html);
        $('.select').select2({
            minimumResultsForSearch: Infinity,
            placeholder: 'Выберите...'
        });

        color_row++;
    }


    // сортировать цвета салона
    $(document).on('click', '.btn-sorting-color', function () {
        var ids = new Array();
        $('.sortable_icolor tr').each(function () {
            console.log($(this).attr('data-id'))

            ids.push($(this).attr('data-id'));
        })
        $.post( "{$generate_url|substr:0:-1}?action=sortByColors", { imageIds : ids }, function() {
            $('.btn-sorting-color').removeClass('show');
            new Noty({ text: 'Цвета салона отсортированы', type: 'success' }).show();
        });
    })


    // Добавление варианта
    $(document).on('click', '.add_variant', function() {
        // если есть то клонируем tr
        if ($('.variant_name').is('.show')) {
            const parent = $('.table_variants tbody:first');
            const clone = parent.children(':last').clone();
            const index = parseInt(clone.find('input:first').attr('name').match(/\[([0-9]+)\]/)[1]) + 1;

            // Очистить значения клонирования и обновить индекс
            clone.find('input, select').val('').each(function() {
                $(this).attr('name', $(this).attr('name').replace(/\[[0-9]+\]/, '[' + index + ']'));
            }).end().appendTo(parent);
        }
        // если нету то добавляем поле с классом variant_name
        else {
            $('.table_variants th.variant_name, .table_variants td.variant_name').addClass('show');
        }

        return false;
    });

    // Удаление варианта
    $(document).on('click', '.del_variant', function() {
        if ($("#variants tr").length > 1) {
            $(this).closest("tr").fadeOut(200, function() {
                $(this).remove();
            });
        } else {
            $('.table_variants th.variant_name, .table_variants td.variant_name').removeClass('show');
            $('.table_variants .variant_name input[name*=variant][name*=name]').val('');
        }

        return false;
    });


    var OptionsList = function() {

        var showSectionFeatures = function(sectionId) {

            $('#features_card').removeClass('collapse');
            $('ul.features-list').empty();


            $.post('{$adminUrl}/product', { action: 'features', sectionId: sectionId, id: {$product.productId|default:0} }, function(response) {
                $.each(response, function(index, feature) {
                    console.log(feature)
	                var line = $('<li class="d-flex p-2 media feature" >' +
                        '<label class="col-4 mb-0 me-auto property"></label>' +
                        '<div class="col-8">' +
	                        '<div class=" input-group">' +
			                    '<input class="form-control" type="text" />' +
			                    '<input class="form-control" type="text" />' +
		                    '</div>' +
		                '</div>' +
                        '</li>');

                    var optionList = line.clone(true);
                    optionList.find("label").text(feature.name);
                    optionList.find("input").attr('name', "options["+feature.id+"]").val(feature.value).next('input').attr('name', "icons["+feature.id+"]").val(feature.fileName);
                    optionList.appendTo('ul.features-list').find("input")
                        .autocomplete({
                            serviceUrl:'{$adminUrl}/product&action=featureId',
                            minChars:0,
                            params: { featureId: feature.id },
                            noCache: false
                        });
                });
            });
            return false;
        };


        var _componentOptions = function() {

            $('select#sectionId:first').change(function() {
                showSectionFeatures($("option:selected",this).val());
            });

            // Добавление нового свойства товара
            var new_feature = $('#new_feature').clone(true);
            $('#new_feature').remove().removeAttr('id');
            $('#add_new_feature').click(function() {
                $(new_feature).clone(true).appendTo('ul.new_features').fadeIn('slow').find("input[name*=new_feature_name]").focus();
                return false;
            });

        };


        return {
            init: function() {
                _componentOptions();
            }
        }
    }();

    document.addEventListener('DOMContentLoaded', function() {
        OptionsList.init();
    })


    // meta date
    $(function () {
        function e() { keywords_touched || $("#keywords").val(i()), description_touched || $("#description").val(t()), fileName_touched || $("#fileName").val(n()) }
        function i() { return name = $("#title").val() }
        function t() { return name = $("#title").val() }
        function n() { return fileName = $("#title").val(), fileName = fileName.replace(/[\s]+/gi, "{$config.filename_word_separator}"), fileName = l(fileName), fileName = fileName.replace(/[^0-9a-z_\-]+/gi, "").toLowerCase() }
        function l(e) {
            for (var a = "А-а-Б-б-В-в-Ґ-ґ-Г-г-Д-д-Е-е-Ё-ё-Є-є-Ж-ж-З-з-И-и-І-і-Ї-ї-Й-й-К-к-Л-л-М-м-Н-н-О-о-П-п-Р-р-С-с-Т-т-У-у-Ф-ф-Х-х-Ц-ц-Ч-ч-Ш-ш-Щ-щ-Ъ-ъ-Ы-ы-Ь-ь-Э-э-Ю-ю-Я-я".split("-"), i = "A-a-B-b-V-v-G-g-G-g-D-d-E-e-E-e-E-e-ZH-zh-Z-z-I-i-I-i-I-i-J-j-K-k-L-l-M-m-N-n-O-o-P-p-R-r-S-s-T-t-U-u-F-f-H-h-TS-ts-CH-ch-SH-sh-SCH-sch-'-'-Y-y-'-'-E-e-YU-yu-YA-ya".split("-"), t = "", n = 0, l = e.length; l > n; n++) {
                var o = e.charAt(n),c = a.indexOf(o);t += c >= 0 ? i[c] : o
            }
            return t
        }
        keywords_touched = !0, description_touched = !0, fileName_touched = !0,
        ($("#keywords").val() == i() || "" == $("#keywords").val()) && (keywords_touched = !1),
        ($("#description").val() == t() || "" == $("#description").val()) && (description_touched = !1),
        ($("#fileName").val() == n() || "" == $("#fileName").val()) && (fileName_touched = !1),
            $("#keywords").change(function () { keywords_touched = !0 }),
            $("#description").change(function () { description_touched = !0 }),
            $("#fileName").change(function () { fileName_touched = !0 }),
            $("#title").keyup(function () { e() })
    });

</script>
