<form action="{$adminUrl}/telegrams" method="post" id="settings" autocomplete="off">

    {capture name="buttons"}
		<button class="btn btn-sm btn-primary" type="submit" name="action" value="save"><i class="ph-floppy-disk me-2"></i>{general:save}</button>
    {/capture}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/telegrams" class="breadcrumb-item">{$title}</a>
    {/capture}

    {capture name="showBy"}
		<button type="button" class="btn btn-light" data-bs-toggle="modal" data-bs-target="#modal_full"> Инструкция по настройке модуля </button>
    {/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}

	<div class="content">

		<div class="card border shadow-sm">
			<div class="card-header d-flex justify-content-between m-0 p-0">
				<ul class="nav nav-tabs nav-tabs-overline nav-tabs-highlight fs-base border-top-0">

					<li class="nav-item">
						<a class="nav-link fs-sm active show" href="#general" data-bs-toggle="tab">
							<div class="d-flex align-items-center">
								<i class="ph-gear bg-primary text-primary bg-opacity-10 rounded p-1 me-2"></i>
								<span class="fw-semibold">{settings:tabs:general}</span>
							</div>
						</a>
					</li>
					<li class="nav-item">
						<a class="nav-link fs-sm" href="#users" data-bs-toggle="tab">
							<div class="d-flex align-items-center">
								<i class="ph-shield-check bg-primary text-primary bg-opacity-10 rounded p-1 me-2"></i>
								<span class="fw-semibold"> Настройки пользователей</span>
							</div>
						</a>
					</li>
					<li class="nav-item">
						<a class="nav-link fs-sm" href="#contacts" data-bs-toggle="tab">
							<div class="d-flex align-items-center">
								<i class="ph-identification-card bg-primary text-primary bg-opacity-10 rounded p-1 me-2"></i>
								<span class="fw-semibold"> Шаблоны уведомлений</span>
							</div>
						</a>
					</li>
					<li class="nav-item">
						<a class="nav-link fs-sm" href="#logs" data-bs-toggle="tab">
							<div class="d-flex align-items-center">
								<i class="ph-identification-card bg-primary text-primary bg-opacity-10 rounded p-1 me-2"></i>
								<span class="fw-semibold">Логи</span>
							</div>
						</a>
					</li>
				</ul>
			</div>

			<div class="card-body m-0 p-0">
				<div class="tab-content mb-0 p-3">
					<div class="tab-pane fade show active" id="general">
						<fieldset class="">
							<div class="row mb-3">
								<label class="col-form-label col-lg-4">{general:status}</label>
								<div class="col-lg-8">
                                    {html_options options=$statuses name="telegram[status]" id="status" selected=$telegram.status|default:'V' class="form-control select"}
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-4">Telegram Bot Ключ (токен)<a href="" class="ms-1" data-bs-toggle="modal" data-bs-target="#modal_default"><i class="ph-question"></i></a></label>
								<div class="col-lg-8">
									<div class="input-group">
										<input class="form-control" type="text" name="telegram[telegram_key]" value="{$telegram.telegram_key}" id="telegram_key">
										<button class="btn btn-light" type="button" onclick="webhook('telegram');">Проверить</button>
									</div>
									<input type="hidden" name="telegram[webhook]" value="{if isset($telegram.webhook)}{$telegram.webhook}{else}no{/if}" />
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-4">Длинное сообщение<a href="" class="ms-1"><i class="ph-question"></i></a></label>
								<div class="col-lg-8">
									<div class="form-check form-check-inline">
										<input type="radio" class="form-check-input" name="telegram[trim_messages]" value="1" id="crop" {if $telegram.trim_messages eq 1}checked=""{/if}>
										<label class="form-check-label" for="crop">Обрезать</label>
									</div>
									<div class="form-check form-check-inline">
										<input type="radio" class="form-check-input" name="telegram[trim_messages]" value="0" id="smash" {if $telegram.trim_messages eq 0}checked=""{/if}>
										<label class="form-check-label" for="smash">Разбивать</label>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-4">Таймаут соединения<a href="" class="ms-1"><i class="ph-question"></i></a></label>
								<div class="col-lg-2">
									<input class="form-control" type="text" name="telegram[timeout]" value="{$telegram.timeout}" placeholder="5">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-4">Использовать прокси<a href="" class="ms-1"><i class="ph-question"></i></a></label>
								<div class="col-lg-8">
									<div class="form-check form-check-inline">
										<input type="radio" class="form-check-input" name="telegram[proxy]" value="1" id="yes_proxy" {if $telegram.proxy eq 1}checked=""{/if} onclick="collapseProxy(this);">
										<label class="form-check-label" for="yes_proxy">Да</label>
									</div>
									<div class="form-check form-check-inline">
										<input type="radio" class="form-check-input" name="telegram[proxy]" value="0" id="not_proxy" {if $telegram.proxy eq 0}checked=""{/if} onclick="collapseProxy(this);">
										<label class="form-check-label" for="not_proxy">Нет</label>
									</div>
								</div>
							</div>
							<div class="row mb-3 collapse_proxy collapse {if $telegram.proxy eq 1}show{/if} ">
								<label class="col-form-label col-lg-4">Прокси (только Socks 5!)<br>
									<button type="button" class="btn btn-outline-primary my-2 add_proxy" onclick="addProxy();">Добавить прокси</button>
								</label>

								<div class="col-lg-8">
									<div class="table-responsive">
										<table class="table table_proxy" id="proxy_block">
											<thead id="header">
											<tr>
												<th width="30">Использовать</th>
												<th class="variant_name">IP-адрес</th>
												<th>Порт</th>
												<th>Логин</th>
												<th>Пароль</th>
												<th>Удалить</th>
											</tr>
											</thead>

											<tbody id="proxys" class="proxys">
                                            {assign var=count_telegram_proxydata value=0}
                                            {if isset($telegram.telegram_proxy_data)}
	                                            {foreach $telegram.telegram_proxy_data as $proxy_data}
		                                            <tr id="proxy-{$count_telegram_proxydata}">
			                                            <td class="text-center">
				                                            <div class="form-check mb-2">
					                                            <input type="checkbox" class="form-check-input" name="telegram_proxy_data[{$count_telegram_proxydata}][status]" {if isset($proxy_data.status) && $proxy_data.status eq 'on'}checked{/if}>
				                                            </div>
			                                            </td>
			                                           <td>
				                                           <input type="text" name="telegram_proxy_data[{$count_telegram_proxydata}][ip]" value="{$proxy_data.ip}" placeholder="IP-адрес"  class="form-control" />
			                                           </td>
			                                            <td><input type="text" name="telegram_proxy_data[{$count_telegram_proxydata}][port]" value="{$proxy_data.port}" placeholder="Порт"  class="form-control" /></td>
			                                           <td><input type="text" name="telegram_proxy_data[{$count_telegram_proxydata}][login]" value="{$proxy_data.login}" placeholder="Логин"  class="form-control" /></td>
			                                            <td><input type="text" name="telegram_proxy_data[{$count_telegram_proxydata}][password]" value="{$proxy_data.password}" placeholder="Пароль"  class="form-control" /></td>
			                                            <td class="text-center">
			                                                <button type="button" class="btn btn-link text-danger del_proxy" onclick="confirm('Данное действие необратимо. Вы уверены?') ? $('#proxy-{$count_telegram_proxydata}').remove() : false;"><i class="ph-trash"></i></button>
			                                            </td>
		                                           </tr>

                                                    {assign var=count_telegram_proxydata value=$count_telegram_proxydata+1}
	                                            {/foreach}
	                                        {/if}
{*												<tr>*}
{*													<td class="move_list">*}
{*														<div class="form-check mb-2"><input type="checkbox" class="form-check-input" name="telegram_proxy_data[0][checked]"></div>*}
{*													</td>*}
{*													<td><input class="form-control" type="text" name="telegram_proxy_data[0][ip]" value="" autocomplete="off" placeholder="IP-адрес"/></td>*}
{*													<td><input class="form-control" type="text" name="telegram_proxy_data[0][port]" value="" autocomplete="off" placeholder="Порт"/></td>*}
{*													<td><input class="form-control" type="text" name="telegram_proxy_data[0][login]" value="" autocomplete="off" placeholder="Логин"/></td>*}
{*													<td><input class="form-control" type="text" name="telegram_proxy_data[0][password]" value="" autocomplete="off" placeholder="Пароль"/></td>*}
{*													<td>*}
{*														<input class="form-control" type="hidden" name="telegram_proxy_data[0][id]" value="" />*}
{*														<button type="button" class="btn btn-link text-danger del_proxy"><i class="ph-trash"></i></button>*}
{*													</td>*}
{*												</tr>*}
{*                                            {/foreach}*}
											</tbody>

										</table>
									</div>
								</div>
							</div>

						</fieldset>
					</div>

					<div class="tab-pane fade" id="users">
						<div class="mb-3">
							<div class="table-responsive">
								<table class="table table_users" id="users_block">
									<thead id="header">
										<tr>
											<th class="text-start" width="40%">Администратор</th>
											<th class="text-start">telegram ID</th>
											<th class="text-center">Уведомлять</th>
											<th class="text-center" width="30">Удалить</th>
										</tr>
									</thead>

									<tbody id="users" class="variants sortable-table">
                                        {foreach from=$users item=user key=key}

	                                        <tr id="group-' group_row '">
	                                            <td>{$user.loginName}</td>
		                                        <td>
			                                        <input type="text" name="telegram_user_data[{$key}][id_telegram]" value="{$telegram.telegram_user_data[$user.userId].id_telegram}" placeholder="telegram ID"  class="form-control" />
		                                        </td>
			                                    <td>
				                                    <div class="d-flex align-items-center justify-content-center">
					                                    <div class="form-check">
						                                    <input type="checkbox" class="form-check-input" name="telegram_user_data[{$user.userId}][checked]" {if isset($telegram.telegram_user_data[$user.userId].checked)}checked{/if}>
					                                    </div>
				                                    </div>
			                                    </td>
	                                            <td class="text-center"></td>
	                                        </tr>
                                        {/foreach}
									</tbody>
									<tfoot>

									</tfoot>
								</table>
								<hr>
								<div class="text-start mt-2">
									<button type="button" class="btn btn-outline-primary add_user" onclick="addUser();">Добавить пользователя</button>
								</div>
							</div>


						</div>
					</div>

					<div class="tab-pane fade" id="contacts">
						<fieldset class="">
							<div class="row mb-3">
								<label class="col-form-label col-lg-3">Read only textarea</label>
								<div class="col-lg-9">
									<textarea rows="3" cols="3" class="form-control" placeholder="Enter your text"></textarea>
								</div>
							</div>
						</fieldset>
					</div>

					<div class="tab-pane fade" id="logs">
						<fieldset class="">
							<div class="mb-3">
								<p class="fw-semibold">Уровни логирования:</p>
								<ol class="fs-sm">
									<li>Выключены - логи не пишутся<span class="text-success"> - рекомендуемый режим!</span></li>
									<li>Только ошибки - в логи пишутся только ошибки соединения (ошибки cURL или ответ с ошибкой от сервера месседжера)</li>
									<li>Полные - в логи пишутся все запросы: успешные и ошибочные, также пишется тест уведомлений.<span class="text-danger"> Не рекомендуется использовать, только в режиме отладки!</span></li>
								</ol>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-2">{general:status}

								</label>
								<div class="col-lg-6">
									<div class="input-group">
                                        {html_options options=$logs  name="telegram[logs]" id="logs" selected=$telegram.logs|default:'0' class="form-control select"}
									</div>
								</div>
								<div class="col-lg-4">
									<div class="input-group">
										<button class="btn btn-danger" type="button" onclick="clearLog('telegram');"><i class="ph-download me-2"></i> Удалить</button>
										<button class="btn btn-primary" type="button" onclick="downloadLog('telegram');"><i class="ph-download me-2"></i> Скачать</button>
									</div>
								</div>
							</div>
							<div class="mb-3">
								<textarea id="log_telegram" rows="6" cols="3" class="form-control form-control-sm" disabled>{$logs_file nofilter}</textarea>
							</div>
						</fieldset>
					</div>

				</div>
			</div>
		</div>


		<div class="col-md-12 main main_buttons text-center">
            {$smarty.capture.buttons nofilter}
		</div>

	</div>

</form>

<div id="modal_full" class="modal fade">
	<div class="modal-dialog modal-full">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Инструкция по настройке модуля</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
			</div>

			<div class="modal-body">
				<h3 class="h3">Вкладка <i class="fa fa-cog"></i> Общие</h3>
				<div>
					<div class="mb-4">
						<h5>Шаг 1.</h5>
						<p class="fw-semibold">Статус: общий выключатель для всего модуля.</p>
						<img src="/admin/assets/telegram/status.jpg" alt="status" title="status" style="max-width: 100%;">
					</div>

					<div class="mb-4">
						<h5>Шаг 2.</h5>
						<p class="fw-semibold">Bot Ключ (токен): для работы модуля необходим токен каждого месседжера.</p>
					</div>

					<div class="mb-4">
						<a href="#help_bot_telegram" data-bs-toggle="collapse" class="btn btn-primary">Как получить Telegram Bot Ключ (токен)</a>

						<div class="collapse" id="help_bot_telegram">
							<p>Для создания бота нужен.. бот. Называется он <a href="tg://resolve?domain=BotFather">@BotFather</a>. Этот бот поможет вам создать новые боты и изменить настройки для существующих. (подробнее можно прочитать на <a href="https://core.telegram.org/bots#6-botfather">официальном сайте</a>).</p>
							<img src="/admin/assets/telegram/botfarther.jpg" alt="botfarther" title="botfarther" style="max-width: 100%;">
							<p>1. Зайдите в программу Telegram на вашем устройстве. В поиске введите <a href="tg://resolve?domain=BotFather">@BotFather</a>.</p>
							<img src="/admin/assets/telegram/gixoc_telegram1.jpg" alt="gixoc_telegram" title="gixoc_telegram" style="max-width: 100%;">
							<p>2. Нажмите «Начать».</p>
							<img src="/admin/assets/telegram/gixoc_telegram2.jpg" alt="gixoc_telegram" title="gixoc_telegram" style="max-width: 100%;">
							<p>3. Выведется весь список команд по управлению ботами. Нас интересует только команда «/newbot». Нажмите на её (ну или введите вручную на клавиатуре).</p>
							<img src="/admin/assets/telegram/gixoc_telegram3.jpg" alt="gixoc_telegram" title="gixoc_telegram" style="max-width: 100%;">
							<p>4. Вам предложат ввести название вашего бота. Оно будет отображается в контактной информации. Например — GixOC Bot.</p>
							<img src="/admin/assets/telegram/gixoc_telegram4.jpg" alt="gixoc_telegram" title="gixoc_telegram" style="max-width: 100%;">
							<p>5. Далее попросят ввести короткое имя, которое будет использоваться ссылке. Оно имеет длину 5-32 символа и не чувствительно к регистру, но может содержать только латинские символы, цифры и символ подчеркивания. Оно должно заканчиваться на «Bot», например «GixOC_Bot» или «GixOCBot».</p>
							<img src="/admin/assets/telegram/gixoc_telegram5.jpg" alt="gixoc_telegram" title="gixoc_telegram" style="max-width: 100%;">
							<p>6. В появившемся сообщении после «Use this token to access the HTTP API:» Вы увидите необходимый токен вида 111111111:ABCDEFGz53dghKds6eBp</p>
							<img src="/admin/assets/telegram/gixoc_telegram6.jpg" alt="gixoc_telegram" title="gixoc_telegram" style="max-width: 100%;">
						</div>

						<a href="#help_bot_viber" data-bs-toggle="collapse" class="btn btn-primary">Как получить Viber Bot Ключ (токен)</a>
						<div class="collapse" id="help_bot_viber">
							<p>1. С начала авторизуйтесь по следующей ссылке — <a href="https://partners.viber.com/">https://partners.viber.com/</a></p>
							<p>а. В открывшейся форме введите номер вашего телефона и нажмите кнопку «Войти»</p>
							<img src="/admin/assets/telegram/gixoc_viber1.jpg" alt="gixoc_viber" title="gixoc_viber" style="max-width: 100%;">
							<p>б. Далее вам в Viber придет одноразовый пароль, введите введите его в следующей форме и нажмите кнопку «Дальше». Попадёте в личный кабинет.</p>
							<img src="/admin/assets/telegram/gixoc_viber2.jpg" alt="gixoc_viber" title="gixoc_viber" style="max-width: 100%;">
							<p>2. В левом меню нажмите кнопку «Создать бот»</p>
							<img src="/admin/assets/telegram/gixoc_viber3.jpg" alt="gixoc_viber" title="gixoc_viber" style="max-width: 100%;">
							<p>Заполните открывшуюся форму:<br>
										Account Image — выберете картинку бота (можно, к примеру, логотип)<br>
										В поле Account Name введите название бота<br>
										В поле Uri — короткое имя, которое будет использоваться ссылке<br>
										Выберете Category (категорию), Subcategory (подкатегорию), Language (язык).<br>
										В поле Account Description введите описание<br>
										В поле Website Address — адрес сайта (не обязательно)<br>
										Email Address — ваш e-mail<br>
										Location — местоположение<br>
										Country — страну (не обязательно)
							</p>
							<img src="/admin/assets/telegram/gixoc_viber4.jpg" alt="gixoc_viber" title="gixoc_viber" style="max-width: 100%;">
							<p>4. Поставьте «галочку» согласия с условиями и нажмите «Create»</p>
							<img src="/admin/assets/telegram/gixoc_viber5.jpg" alt="gixoc_viber" title="gixoc_viber" style="max-width: 100%;">
							<p style="color: red;">Первую галочку ставить не нужно!</p>
							<img src="/admin/assets/telegram/gixoc_viber7.jpg" alt="gixoc_viber" title="gixoc_viber" style="max-width: 100%;">
							<p>5. Появится форма с необходимым токеном.</p>
							<img src="/admin/assets/telegram/gixoc_viber6.jpg" alt="gixoc_viber" title="gixoc_viber" style="max-width: 100%;">
						</div>
					</div>

					<div class="mb-4">
						<h5>Шаг 3.</h5>
						<p>Полученный на предыдущем шаге токен введите в соответствующее поле.</p>
						<img src="/admin/assets/telegram/telegram_token.jpg" alt="telegram_token" title="telegram_token" style="max-width: 100%;">
						<img src="/admin/assets/telegram/viber_token.jpg" alt="viber_token" title="viber_token" style="max-width: 100%;">
					</div>

					<div class="mb-4">
						<h5>Другие настройки</h5>

						<p><span class="fw-semibold">Длинное сообщение:</span> у месседжеров есть ограничение по количеству отправляемых символов в одном сообщении (у Telegramа - 4096, у Viberа - 7000). Данной настройкой Вы устанавливаете, что делать с сообщениями, длинее указанного числа: обрезать или разбивать на несколько сообщений.</p>
						<img src="/admin/assets/telegram/trim_messages.jpg" alt="trim_messages" title="trim_messages" style="max-width: 100%;">
						<p><u>Таймаут соединения</u>: максимальное количество секунд подключения к серверам месседжеров. Не рекомендуется выставлять больше 5 секунд!</p>
						<img src="/admin/assets/telegram/timeout.jpg" alt="timeout" title="timeout" style="max-width: 100%;">

						<p><span class="fw-semibold">Использовать прокси</span>: в связи с блокировкой Telegram на территории РФ, добавлена возможность отправки сообщений через прокси. На данный момент реализован только Socks 5! Возможно указать несколько прокси, на случай, если используемый заблокируют. Не рекомендуется использовать много прокси, т.к. это может привести к задержкам про оформлении заказа, регистрации нового покупателя и т.д.!</p>
						<img src="/admin/assets/telegram/proxy.jpg" alt="proxy" title="proxy" style="max-width: 100%;">
						<p>Вы можете использовать бесплатные прокси от <a target="_blank" href="http://spys.one/">SPYS.ONE</a>. Самыми надежными считаются <a href="http://spys.one/proxys/US/" target="_blank">американские</a>, <a href="http://spys.one/proxys/DE/" target="_blank">немецкие</a>, <a href="http://spys.one/proxys/SE/" target="_blank">шведские</a> и <a href="http://spys.one/proxys/GB/" target="_blank">британские</a>.</p>
						<p>Необходимые данные получаем так:<br>1) Справа вверху выбираем тип SOCKS 5<br>2) Выбираем любую строку. То, что стоит за скобками в шестой колонке копируем в IP-адрес <br>3) В поле IP-адреса SOCKS 5, за двоеточием, стоят цифры — их нужно скопировать в строку Порт. <br>4) Ставим галочку "Использовать". <br>5) Нажимаем кнопку "Проверить". <br> Возможно, не сразу получится подобрать рабочий прокси!</p>
						<img src="/admin/assets/telegram/proxy_spys.jpg" alt="proxy_spys" title="proxy_spys" style="max-width: 100%;">
					</div>
					<div class="mb-4">
						<h5>Шаг 4.</h5>
						<p class="text-danger">Обязательно (!) нажмите на кнопку <a class="btn btn-primary"><i class="fa fa-retweet"></i> Применить</a></p>
						<p>В случае успешной проверки появится сообщение</p>
						<img src="/admin/assets/telegram/success_token.jpg" alt="success_token" title="success_token" style="max-width: 100%;">
						<p>В случае ошибки подключения появится сообщение</p>
						<img src="/admin/assets/telegram/error_token.jpg" alt="error_token" title="error_token" style="max-width: 100%;">
					</div>
				</div>

				<h3>Вкладка <i class="fa fa-users"></i> Настройки пользователей</h3>
				<div>
					<div class="mb-4">
						<p>Далее настраиваем уведомления для каждого администратора магазина.</p>
						<p>Обращаем ваше внимание на следущее: на этой и последующих вкладках указаны настройки для каждого месседжера отдельными вкладками! Учитывайте это при настройке.</p>
						<img src="/admin/assets/telegram/tab.jpg" alt="tab" title="tab" style="max-width: 100%;">
					</div>
					<div class="mb-4">
						<h5>Шаг 5.</h5>
						<p>Для получения уведомлений конкретным администратором необходимо <u>указать его ID</u> из мессенджера</p>

						<a href="#help_id_telegram" data-bs-toggle="collapse" class="btn btn-primary">Как получить ID пользователя в Telegram</a>
						<div class="collapse" id="help_id_telegram">
							<div class="mb-4">
								<h5>С помощью вашего бота:</h5>
								<p>1. <b>Откройте ваш бот.</b> Для этого перейдите по ссылке <a href=""></a>. Или отсканируйте этот QR-код на вашем устройстве.</p>
								<div id="qrcode"><canvas width="256" height="256"></canvas><img style="display: none;"></div>
								<p>2. <b>Отправьте боту команду</b> /start . Или нажмите "Начать".</p>
								<p>3. В ответ Вам <b>бот пришлет ID</b> вида 123456789. Скопируйте его в поле telegram ID.</p>
							</div>
							<div class="mb-4">
							<h5>С помощью сторонних ботов:</h5>
								<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i><b> Внимание!</b> В случае получения telegram ID с помощью сторонних ботов, <b>обязательно</b> отравьте любое сообщение своему боту!</div>
								<p>1. <b>Узнать ID можно с помощью сторонних ботов.</b> Для этого перейдите по любой ссылке, из списка ниже:<br></p>
								<ul>
									<li class="page-header"><a target="_blank" href="tg://resolve?domain=userinfobot">@userinfobot</a></li>
									<li class="page-header"><a target="_blank" href="tg://resolve?domain=GixOC_NotificationsBot">@GixOC_NotificationsBot</a> - бот автора модуля, с возможностью заказа поддержки</li>
									<li class="page-header"><s><a target="_blank" href="tg://resolve?domain=MyTelegramID_bot">@MyTelegramID_bot</a></s> - <a style="color: red;"> не рабочий!</a></li>
									<li class="page-header"><s><a target="_blank" href="tg://resolve?domain=showmeidbot">@ShowMeID</a></s> - <a style="color: red;"> не рабочий!</a></li>
									<li class="page-header"><s><a target="_blank" href="tg://resolve?domain=my_id_bot">@my_id_bot</a></s> - <a style="color: red;"> не рабочий!</a></li>
								</ul>
								<p>2. <b>Отправьте боту команду</b> /start . Или нажмите "Начать".</p>
								<p>3. В ответ Вам <b>бот пришлет ID</b> вида 123456789. Скопируйте его в поле telegram ID.</p>
							</div>
							<div class="mb-4">
								<h5>Для того, чтобы бот мог отправлять сообщения в группу, добавьте его в группу</h5>
							</div>
							<a href="#help_add_bot_telegram" data-bs-toggle="collapse" class="btn btn-primary">Как добавить бота в группу</a>
							<div class="collapse" id="help_add_bot_telegram">
								<p class="page-header">1. Нажмите на иконку группы.</p>
								<img src="/admin/assets/telegram/gixoc_telegram_bot1.jpg" alt="gixoc_telegram_bot" title="gixoc_telegram_bot" style="max-width: 100%;">
								<p>2. В открывшихся настройках нажмите "Добавить участников".</p>
								<img src="/admin/assets/telegram/gixoc_telegram_bot2.jpg" alt="gixoc_telegram_bot" title="gixoc_telegram_bot" style="max-width: 100%;">
								<p>. Нажмите на ввод.</p>
								<img src="/admin/assets/telegram/gixoc_telegram_bot3.jpg" alt="gixoc_telegram_bot" title="gixoc_telegram_bot" style="max-width: 100%;">
								<p>4. Введите название вашего бота.</p>
								<img src="/admin/assets/telegram/gixoc_telegram_bot4.jpg" alt="gixoc_telegram_bot" title="gixoc_telegram_bot" style="max-width: 100%;">
								<p>5. И нажмите "Готово".</p>
								<img src="/admin/assets/telegram/gixoc_telegram_bot1.jpg" alt="gixoc_telegram_bot" title="gixoc_telegram_bot" style="max-width: 100%;">
							</div>
							<p>Далее необходимо получить ID группы в Telegram. Вы можете это сделать</p>
							<p>- с помощью <a href="">вашего бота</a>. Вы его получите <b>автоматически в сообщении от бота</b>, сразу после добавления бота в группу.</p>
							<p>- с помощью нашего бота: <a href="tg://resolve?domain=GixOC_NotificationsBot">@GixOC_NotificationsBot</a>. Это безопасно, по правилам Telegram, бот не имеет домтупа к сообщениям в группе без соответствующих прав. Для получения ID добавьте бота в нужную группу, и он Вам отправит в сообщении ID группы. Не забудьте удалить его после этого из группы.</p>
							<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i><b> Внимание!</b> Полученный в сообщении ID, <b>обязательно</b> копируйте со знаком "минус"!</div>
						</div>


						<a href="#help_id_viber" data-bs-toggle="collapse" class="btn btn-primary">Как получить ID пользователя в Viber</a>
						<div class="collapse" id="help_id_viber">
							<div class="mb-4">
								<h5>Для получения ID необходимо сначала:</h5>
								<p>1. Получить Viber Bot Ключ (токен) по инструкции</p>
								<p>2. Ввести его в приложение</p>
								<p>3. Нажать кнопку <a class="btn btn-primary"><i class="fa fa-retweet"></i> Применить</a><br></p>
								<p>Затем Вы можете получить ID</p>
							</div>
							<div class="mb-4">
								<h5>С помощью вашего бота:</h5>
								<div class="h4">
									<p>1. <b>Откройте ваш бот.</b></p>
									<p>2. <b>Отправьте боту команду</b> /start . Или нажмите "Начать".</p>
									<p>3. В ответ Вам <b>бот пришлет ID</b> вида 1234567890ABcde=-. Скопируйте его в поле viber ID.</p>
								</div>

							</div>
						</div>
					</div>
					<div class="mb-4">
						<h5>Шаг 6.</h5>
						<p>Полученный на предыдущем шаге ID введите в соответствующее поле.</p>
						<img src="/admin/assets/telegram/telegram_id.jpg" alt="telegram_token" title="telegram_token" style="max-width: 100%;">
						<img src="/admin/assets/telegram/viber_id.jpg" alt="viber_token" title="viber_token" style="max-width: 100%;">
					</div>
					<div class="mb-4">
						<h5>Шаг 7.</h5>
						<p>На данный момент реализованы уведомления о новых: заказе, покупателе, партнере, отзыве и возврате.</p>
						<img src="/admin/assets/telegram/users.jpg" alt="users" title="users" style="max-width: 100%;">
						<p>Так же добавлены уведомления о смене статуса заказа. Можно для каждого заказа указать свое уведомление. Уведомления приходят при: редактировании заказа в админке, смене статуса платежным модулем (если он использует стандартный функционал Opencart) и при новом заказе (возможно дублирование уведомлений). </p>
						<img src="/admin/assets/telegram/orders.jpg" alt="orders" title="orders" style="max-width: 100%;">
					</div>
				</div>

				<h3>Вкладка <i class="fa fa-envelope"></i> Шаблоны уведомлений</h3>
				<div>
					<div class="mb-4">
						<h5>Шаг 8.</h5>
						<p>Далее Вы можете настроить шаблон для каждого типа уведомления. Справа от каждого поля расположен блок поддерживаемых переменных. HTML разметка не поддерживается!</p>
						<img src="/admin/assets/telegram/template.jpg" alt="template" title="template" style="max-width: 100%;">
					</div>
				</div>
				<h3>Вкладка <i class="fa fa-book"></i> Логи</h3>
				<div>
					<div class="mb-4">
						<h5>Шаг 9.</h5>
						<p><span class="fw-semibold">Настройка логов</span></p>
						<div>
							<p>Модуль использует отдельный файл логов для каждого из месседжеров.</p>
							<label>Уровни логирования:</label>
							<p>1. Выключены - логи не пишутся<a class="text-success"> - рекомендуемый режим!</a></p>
							<p>2. Только ошибки - в логи пишутся только ошибки соединения (ошибки cURL или ответ с ошибкой от сервера месседжера)</p>
							<p>3. Полные - в логи пишутся все запросы: успешные и ошибочные, также пишется тест уведомлений.<a style="color: red;"> Не рекомендуется использовать, только в режиме отладки!</a></p>
							<img src="/admin/assets/telegram/logs.jpg" alt="logs" title="logs" style="max-width: 100%;">
							<p>Также Вы можете очистить файл логов или скачать его для дальнейшего анализа.</p>
						</div>
					</div>
				</div>

			</div>

			<div class="modal-footer">
				<button type="button" class="btn btn-link" data-bs-dismiss="modal">Закрыть</button>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
        {if isset($errors.htaccess)} new Noty({ text: '{settings:errors:0}', type: 'error' }).show(); {/if}
        {if isset($errors.serializations)} new Noty({ text: '{settings:errors:1}', type: 'error' }).show(); {/if}
        {if isset($messages.saved)} new Noty({ text: '{settings:messages:0}', type: 'success' }).show(); {/if}

    });

    function collapseProxy(element) {
        const collapse_proxy = document.querySelector('.collapse_proxy');
        const currentProxy = element.value;
        if (currentProxy == 1) {
            collapse_proxy.classList.add('show');
        } else {
            collapse_proxy.classList.remove('show');
        }
    }

    // $(document).ready(function() {
    //     addProxy();
    // });
    var proxy_row = {$count_telegram_proxydata};

    function addProxy() {
        html = '    <tr id="proxy-' + proxy_row + '">';
        html += '       <td class="text-center"><div class="form-check mb-2"><input type="checkbox" class="form-check-input" name="telegram_proxy_data[' + proxy_row + '][status]"></div></td>';
        html += '       <td><input type="text" name="telegram_proxy_data[' + proxy_row + '][ip]" value="" placeholder="IP-адрес"  class="form-control" /></td>';
        html += '       <td><input type="text" name="telegram_proxy_data[' + proxy_row + '][port]" value="" placeholder="Порт"  class="form-control" /></td>';
        html += '       <td><input type="text" name="telegram_proxy_data[' + proxy_row + '][login]" value="" placeholder="Логин"  class="form-control" /></td>';
        html += '       <td><input type="text" name="telegram_proxy_data[' + proxy_row + '][password]" value="" placeholder="Пароль"  class="form-control" /></td>';
        html += '       <td class="text-center"><button type="button" class="btn btn-link text-danger del_proxy" onclick="confirm(\'Данное действие необратимо. Вы уверены?\') ? $(\'#proxy-' + proxy_row + '\').remove() : false;"><i class="ph-trash"></i></button></td>';
        html += '   </tr>';

        $('.table_proxy tbody').append(html);
        proxy_row++;
    }

    // $(document).ready(function() {
    //     addUser();
    // });

    var group_row = 0;

    function addUser() {
        html = '    <tr id="group-' + group_row + '">';
        html += '       <td><input type="text" name="telegram_user_data[' + group_row + '][name]" value="" placeholder="Имя получателя"  class="form-control" /></td>';
        html += '       <td><input type="text" name="telegram_user_data[' + group_row + '][id_telegram]" value="" placeholder="telegram ID"  class="form-control" /></td>';
        html += '       <td class="text-center"><div class="d-flex align-items-center justify-content-center"><div class="form-check mb-2"><input type="checkbox" class="form-check-input" name="telegram_user_data[' + group_row + '][checked]"></div></div></td>';
        html += '       <td class="text-center"><button type="button" class="btn btn-link text-danger del_proxy" onclick="confirm(\'Данное действие необратимо. Вы уверены?\') ? $(\'#group-' + group_row + '\').remove() : false;"><i class="ph-trash"></i></button></td>';
        html += '   </tr>';

        $('.table_users tbody').append(html);
        group_row++;
    }

    function webhook(key) {

        var bot_key = $('#' + key + '_key').val(), proxy = $("input[name='telegram[proxy]']:checked").val(),
        timeout = $('input[name="telegram[timeout]"]').val(), proxydata = '';

        if (proxy == '1') {
            for (var i=0; i< proxy_row; i++) {
                if (($('input[name="telegram_proxy_data[' + i + '][status]"]').is(':checked')) && ($('input[name="telegram_proxy_data[' + i + '][ip]"]').val() !== '') && ($('input[name="telegram_proxy_data[' + i + '][port]"]').val() !== '')) {
                    proxydata += $('input[name="telegram_proxy_data[' + i + '][ip]"]').val() + ':' + $('input[name="telegram_proxy_data[' + i + '][port]"]').val();

                    if (($('input[name="telegram_proxy_data[' + i + '][login]"]').val() !== '') || ($('input[name="telegram_proxy_data[' + i + '][password]"]').val() !== '')) {
                        proxydata += '@' + $('input[name="telegram_proxy_data[' + i + '][login]"]').val() + ':' + $('input[name="telegram_proxy_data[' + i + '][password]"]').val();
                    }

                    proxydata += ';';
                }
            }
        }

        $.ajax({
            url: '{$adminUrl}/telegrams?action=set_webhook',
            type: 'post',
            dataType: 'json',
            data: { "telegram[key]": key, "telegram[telegram_key]": bot_key, "telegram[timeout]": timeout, "telegram[proxy]": proxy, "telegram[proxydata]": proxydata },
            success: function(response) {

                new Noty({ text: response.message, type: response.type }).show();

                if (response.webhook) {
                    $('input[name="telegram[webhook]"]').val(response.webhook);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                new Noty({ text: xhr.statusText, type: 'error' }).show();
                console.log(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
                // alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        });
    }


    function help(key) {
        $("#ModalBox").modal('show');
        $.ajax({
            url: '{$adminUrl}/telegrams?action=help',
            type: 'post',
            dataType: 'json',
            data: 'key=' + key,
            success: function(json) {
                if (json['error']) {
                    $(".modal-title").html('Error!');
                    $(".modal-body").html('<div class="h4" style="color:red;text-align:center;">' + json['error'] + '</div>');
                }

                if (json['success']) {
                    $(".modal-title").html(json['header']);
                    $(".modal-body").html(json['success']);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                $("#ModalBox").modal('hide');
                alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        });
    }

    function clearLog(key) {
        $(".modal-body").html('');

        $.ajax({
            url: '{$adminUrl}/telegrams?action=clear_log',
            type: 'post',
            dataType: 'json',
            data: 'key=' + key,
            success: function(response) {
                new Noty({ text: response.message, type: response.type }).show();

                if (response.status == 200) {
                    $('#log_' + key).val('');

                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        });
    }

    function downloadLog(key) {
        $(".modal-body").html('');
        $("#ModalBox").modal('show');
        $.ajax({
            url: '{$adminUrl}/telegrams?action=download_log' + '&key=' + key,
            type: 'GET',
            success: function(json) {
                if (json['error']) {
                    $(".modal-title").html('Error!');
                    $(".modal-body").html('<div class="h4" style="color:red;text-align:center;">' + json['error'] + '</div>');
                }
                else {
                    $("#ModalBox").modal('hide');
                    window.location = '{$adminUrl}/telegrams?action=download_log' + '&key=' + key;
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        });
    }

</script>

