<form method="post" enctype="multipart/form-data" id="manager">

	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/developers"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/developers" class="breadcrumb-item">{$title}</a>
        {if isset($action) && $action == 'edit'}
			<span class="breadcrumb-item active">{managers:editing}</span>
        {else}
			<span class="breadcrumb-item active">{managers:adding}</span>
        {/if}
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="profile-cover">
		<div class="profile-cover-img" style="background-image: url('/admin/assets/img/wallpaper_3.jpg')"></div>
		<div class="d-flex align-items-center text-center text-lg-start flex-column flex-lg-row position-absolute start-0 end-0 bottom-0 mx-3 mb-3">

			<div class="me-lg-3 mb-2 mb-lg-0">
				<div class="profile-thumb">
					<img src="{if isset($manager.image.medium)}{$manager.image.medium}{else}/admin/assets/img/no_images.jpg{/if}" class="img-thumbnail rounded-circle shadow" width="100" height="100" alt="">
				</div>
			</div>


			<div class="profile-cover-text text-white">
				<h1 class="mb-0">{if isset($manager.fullName)}{$manager.fullName}{/if}</h1>
				<span class="d-block">{if isset($manager.accessLevelName)}{$manager.accessLevelName}{/if}</span>
			</div>

			<div class="ms-lg-auto mt-2 mt-lg-0">
				<ul class="d-inline-flex">
{*						<a class="btn btn-light border-transparent read-more"*}
{*						   href="javascript:void('')"*}
{*						   data-type="image"*}
{*						   data-path="/admin"*}
{*						   data-action="read_more"><i class="icon-file-picture mr-2"></i> Изображение обложки </a>*}


						<button class="btn btn-light btn-upload read-more"
					       data-type="image"
					       data-path="admin"
					       data-action="read_more"><i class="ph-image me-2"></i> {if isset($manager.image->medium)}{general:changeFile}{else}{general:uploadFile}{/if}</button>
				</ul>
			</div>
		</div>
	</div>

	<div class="navbar navbar-expand-lg border-bottom py-2">
		<div class="container-fluid">
			<div class="text-center d-lg-none w-100">
				<button type="button" class="navbar-toggler dropdown-toggle" data-toggle="collapse" data-target="#navbar-second">
					<i class="icon-menu7 mr-2"></i>
					Profile navigation
				</button>
			</div>

			<ul class="nav navbar-nav flex-row flex-fill">
				{if $adminManager.userType eq Mnv\Models\Users\UserTypes::DEVELOPER}
					<li class="nav-item me-1">
						<a href="javascript:void('');" class="navbar-nav-link navbar-nav-link-icon rounded" data-bs-toggle="collapse" data-bs-target="#collapse-notice"><i class="icon-stack-text me-2"></i>Заметки</a>
					</li>
				{/if}

				<li class="nav-item me-1">
					<a href="javascript:void('');" class="navbar-nav-link navbar-nav-link-icon rounded" >
						<div class="d-flex align-items-center mx-lg-1">
							<i class="ph-calendar"></i>
							<span class="d-none d-lg-inline-block ms-2">
								Публикаций
								<span class="badge bg-success rounded-pill ms-auto ms-lg-2">{if isset($totalArticle)}{$totalArticle}{else}0{/if}</span>
							</span>
						</div>
					</a>

				</li>
			</ul>
		</div>
	</div>

    <!-- Content area -->
    <div class="content">
        <div class="row">
	        <div class="col-md-12">
		        <div class="card collapse" id="collapse-notice">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">Заметки</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
				        <div class="card-body">
					        <textarea class="form-control p-2" style="width:100%;height:200px;" readonly>{if isset($manager.notice)}{$manager.notice nofilter}{/if}</textarea>
				        </div>
			        </div>
		        </div>
	        </div>

            <div class="col-md-8">
    		    <div class="card border shadow-sm">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">{general:tabs:general}</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
	                    <div class="card-body">
	                        <div class="row">
	                            <div class="col-md-6">
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible {if isset($errors.fullName)}text-danger{/if}">{managers:fullname}</label>
	                                    <input type="text" class="form-control" autocomplete="off" id="fullName" name="manager[fullName]" value="{if isset($manager.fullName)}{$manager.fullName}{/if}" />
	                                </div>
					                <div class="form-group mb-3">
						                <label class="form-label is-visible {if isset($errors.login_empty) || isset($errors.login_exists) || isset($errors.loginName)}text-danger{/if}">{managers:loginname}</label>
						                <input type="text" class="form-control" autocomplete="off" id="loginName" name="manager[loginName]" value="{if isset($manager.loginName)}{$manager.loginName}{/if}" />
					                </div>
	                                <div class="form-group mb-3">
	                                    <label for="email" class="form-label is-visible {if isset($errors.email)}text-danger{/if}">{general:email}</label>
	                                    <input type="email" class="form-control" autocomplete="off" id="email" name="manager[email]" value="{if isset($manager.email)}{$manager.email}{/if}"/>
	                                </div>
	                            </div>

	                            <div class="col-md-6">
		                            <div class="form-group mb-3">
			                            <label class="form-label is-visible">{managers:phone}</label>
			                            <input type="tel" class="form-control" autocomplete="off" id="phone" data-mask="{$config.phone_mask}" name="manager[phone]" value="{if isset($manager.phone)}{$manager.phone}{/if}" />
		                            </div>
		                            <div class="form-group mb-3">
			                            <label for="email" class="form-label is-visible">{managers:address}</label>
			                            <input type="text" class="form-control maxlength-threshold" maxlength="100" autocomplete="off" id="address" name="manager[address]" value="{if isset($manager.address)}{$manager.address}{/if}"/>
		                            </div>

	                                {if !empty($manager.userId)}
		                                <div class="form-group mb-3">
			                                <label class="form-label is-visible {if isset($errors.password)}text-danger{/if}">{managers:newPassword}</label>
			                                <div class="input-group">
				                                <input  type="text" class="form-control group-indicator" id="newPassword" name="manager[newPassword]" />
				                                <span class="input-group-text password-indicator-group">No password</span>
			                                </div>
		                                </div>
	                                {else}
		                                <div class="form-group mb-3">
			                                <label for="password" class="form-label is-visible {if isset($errors.password)}text-danger{/if}">{managers:password}</label>
			                                <div class="input-group">
				                                <input type="text" class="form-control group-indicator" id="password" name="manager[password]"/>
				                                <span class="input-group-text  password-indicator-group">No password</span>
			                                </div>
		                                </div>
	                                {/if}

		                            <button type="button" class="btn btn-info generate-group">Сгенерировать пароль</button>

	                            </div>
				            </div>
	                    </div>
			        </div>
    		    </div>
            </div>

            <div class="col-md-4">
        		<div class="card border shadow-sm">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">{general:card:statusAndVisibility}</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
	                    <div class="card-body border-top-0">
						    <div class="form-group mb-3">
							    <div class="form-check form-switch mb-2">
								    <input type="checkbox" class="form-check-input form-check-input-success" id="receiveEmails" name="manager[receiveEmails]" value="1" {if isset($manager.receiveEmails) AND $manager.receiveEmails eq 1}checked{/if} >
								    <label class="form-check-label" for="receiveEmails">Не получать писем</label>
							    </div>
						    </div>
                            {* field status *}
                            {include file="components/fields/select.tpl" id="status" title="{general:status}" field="manager[status]" array=$statuses selected=$manager.status|default:'visible'   class="form-group mb-3"}
                            {* /field status *}

	                        <div class="form-group mb-3">
	                            <label class="form-label is-visible {if isset($errors.no_more_admins) OR isset($errors.no_more_developers) OR isset($errors.access_level_empty)}text-danger{/if}">Группа</label>
	                            {html_options options=$groups selected=$manager.accessLevel|default:'' id="accessLevel" name="manager[accessLevel]" class="form-control select"}
	                        </div>
	                    </div>

                        {if isset($manager.addedOn) && isset($manager.last_login)}
				        <div class="card-footer hstack gap-3 justify-content-between">
					        <div class="text-muted">
						        <ul class="list list-unstyled mb-0 fs-sm">
                                   <li>{managers:registration}</li>
                                    <li>{managers:activity}</li>
						        </ul>
					        </div>
					        <div class="hstack gap-1">
						        <ul class="list list-unstyled mb-0 fs-sm">
                                    <li>{$manager.addedOn|date_format:"%d.%m.%Y %H:%M"}</li>
                                    <li>{$manager.last_login|date_format:"%d.%m.%Y %H:%M"}</li>
						        </ul>
					        </div>
				        </div>
                        {/if}
			        </div>
    			</div>
            </div>


	        <div class="col-md-12 text-center">
                {if isset($manager.userId)}<input type="hidden" class="form-control" id="id" name="id" value="{$manager.userId}">{/if}
		        {$smarty.capture.buttons nofilter}
	        </div>
        </div>

    </div>

</form>

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>
$(document).ready(function () {

    {if isset($errors.login_empty)}     new Noty({ text: '{managers:errors:13}', type: 'error' }).show(); {/if}
    {if isset($errors.login_exists)}    new Noty({ text: '{managers:errors:0}', type: 'error' }).show(); {/if}
    {if isset($errors.user_not_found)}  new Noty({ text: '{managers:errors:1}', type: 'error' }).show();  {/if}
    {if isset($errors.loginName)}       new Noty({ text: '{managers:errors:2}', type: 'error' }).show(); {/if}
    {if isset($errors.fullName)}        new Noty({ text: '{managers:errors:3}', type: 'error' }).show(); {/if}
    {if isset($errors.password)}        new Noty({ text: '{managers:errors:4}', type: 'error' }).show(); {/if}
    {if isset($errors.not_saved)}       new Noty({ text: '{managers:errors:5}', type: 'error' }).show(); {/if}
    {if isset($errors.no_more_admins)}  new Noty({ text: '{managers:errors:6}', type: 'error' }).show(); {/if}

    {if isset($errors.developer_status)}    new Noty({ text: '{managers:errors:9}', type: 'error' }).show(); {/if}
    {if isset($errors.no_more_developers)}  new Noty({ text: '{managers:errors:10}', type: 'error' }).show(); {/if}
    {if isset($errors.access_level_empty)}  new Noty({ text: '{managers:errors:16}', type: 'error' }).show(); {/if}
    {if isset($errors.invalid_email)}       new Noty({ text: '{managers:errors:12}', type: 'error' }).show(); {/if}
    {if isset($errors.image_not_saved)}     new Noty({ text: '{managers:errors:8}', type: 'error' }).show();{/if}
    {if isset($errors.status_empty)}     new Noty({ text: 'Нужно указать статус', type: 'error' }).show();{/if}

    {if isset($messages.saved)} new Noty({ text: '{managers:messages:0}', type: 'success' }).show(); {/if}
});

	function accessLevelChange() {
	    var accessLevelId = document.getElementById('accessLevel').value;
		//console.log(accessLevelId)
	    $.post('{$adminUrl}/manager?action=accessLevel', { accessLevelId: accessLevelId}, function (response) {
	        console.log(response)
		    if (response.status === 200) {
	            $('.boxed').replaceWith('<div class="boxed fn_toggle_wrap">' + response.permission + '</div>');
	        }
	    })
    }


    // $(document).on("change", ".all_perms", function () {
    //       if($(this).is(":checked")) {
    //           $('.item_perm').each(function () {
    //               if(!$(this).is(":checked")) {
    //                   $(this).trigger("click");
    //                   // console.log($(this).attr('id'))
    //               }
    //           });
    //       } else {
    //           $('.item_perm').each(function () {
    //               if($(this).is(":checked")) {
    //                   $(this).trigger("click");
    //                   // console.log($(this).attr('id'))
    //               }
    //           })
    //       }
    // });
	// $(document).on("change", ".item_perm", function () {
	//     var id = $(this).attr('id');
    //     console.log(id);
    //     if ($(this).is(":checked")) {
    //         $('#parent_'+id).prop('checked', true);
    //     } else {
    //         $('#parent_'+id).prop('checked', false);
    //     }
	//
	// });
</script>
