<?php

namespace Mnv\Http\Resources;

use JsonSerializable;
use Mnv\Core\Collections\Collection;

/**
 * Class MergeValue
 * @package Mnv\Http\Resources
 */
class MergeValue
{
    /**
     * The data to be merged.
     *
     * @var array
     */
    public $data;

    /**
     * Create new merge value instance.
     *
     * @param  \Mnv\Core\Collections\Collection|\JsonSerializable|array  $data
     * @return void
     */
    public function __construct($data)
    {
        if ($data instanceof Collection) {
            $this->data = $data->all();
        } elseif ($data instanceof JsonSerializable) {
            $this->data = $data->jsonSerialize();
        } else {
            $this->data = $data;
        }
    }
}
