<?php

namespace Mnv\Models;

use Mnv\Core\Model;
use Mnv\Http\Request;

/**
 * Class Countries
 * @package Mnv\Models
 */
class Countries extends Model
{
    /** @var string */
    protected string $table = 'geo_countries';
    /** @var string  */
    protected string $primaryKey = 'id';

    protected string $orderBy = 'id ASC';

    public function __construct(Request $request)
    {
        $this->id   = $request->get('id');                  //  getRequestVar('id'),
        $this->data = $request->get('country', '');  //  getRequestVar('country', '', true)
    }


    public function prepare(array $data, int $managerId): bool
    {
        $data['modifiedBy']    = $managerId;
        $data['modifiedOn']    = gmdate('Y-m-d H:i:s');

        if (empty($this->id)) {
            $data['addedBy'] = $managerId;
            $data['addedOn'] = gmdate('Y-m-d H:i:s');
            $data['orderBy'] = $this->getMaxValue('orderBy') + 1;

            if ($this->id = $this->insert($data)) {
                return true;
            }
        }
        else {
            return $this->update($data);
        }

        return false;
    }

    /**
     * @return array|false|mixed|string
     */
    public static function getSelectCountries()
    {
        $countryList = array(0 => 'Выберите город');
        $countryList += connect()->table( 'geo_countries')->select('id, name')->orderBy('id ASC')->indexKey('id')->valueKey('name')->getAllIndexes();

        return $countryList;
    }


    public function checkFileName(?string $fileName)
    {
        // TODO: Implement checkFileName() method.
    }

}