<?php


namespace Mnv\Models\Shop;

use Mnv\Core\Model;
use Mnv\Http\Request;

/**
 * Class Colors
 * @package Mnv\Models\Shop
 */
class Colors extends Model
{
    /** @var string  */
    protected string $table = 'colors';

    /** @var string  */
    protected string $table_image = 'color_images';

    /** @var string  */
    protected string $primaryKey = 'colorId';

    /** @var string  */
    protected string $orderBy = 'orderBy ASC';

   /** @var array|mixed  */
    public $modelIds = [];

    /** @var array|mixed  */
    public $colorIds = [];

    public function __construct(Request $request)
    {
        $this->id           = $request->get('id');
        $this->data         = $request->get('color', '');
        $this->modelIds     = $request->get('modelIds', '');
        $this->colorIds     = $request->get('ids', '');
    }


    public function prepare(array $data, $colorType, int $managerId): bool
    {
        $data['modifiedBy']   = $managerId;
        $data['modifiedOn']   = gmdate('Y-m-d H:i:s');

        if (empty($this->id)) {

            $data['addedBy'] = $managerId;
            $data['addedOn'] = gmdate('Y-m-d H:i:s');
            $data['orderBy'] = connect()->table($this->table)->max('orderBy')->getValue() + 1;
            if ($this->id = $this->insert($data)) {
                return true;
            }
        }
        else {
            return $this->update($data);
        }

        return false;
    }


    public function updateColorModels($colorType): void
    {
        connect()->table('product_colors')->where('colorId', $this->id)->delete();

        if (is_array($this->modelIds)) {
            foreach($this->modelIds as $modelId) {
                connect()->table('product_colors')->insert(['colorId' => $this->id, 'modelId' => $modelId, 'type' => $colorType]);
            }
        }
    }

    /**
     * @return bool
     */
    public function remove(): bool
    {
       if (parent::remove()) {
           connect()->table('product_colors')->where('colorId', $this->id)->delete();
           return true;
       }

       return false;
    }


    /**
     * Получить комплектации цвета
     *
     * @param $colorId
     * @return array|null
     */
    public function getColorModels($colorId): ?array
    {
        return connect()->table('product_colors')->usingJoin('car_models', 'modelId')->select('*')
            ->where('colorId', $colorId)->orderBy('modelId DESC')->indexKey('modelId')->valueKey('title')->getAllIndexes('array');
    }

//    /**
//     * Получить IDS комплектации цвета
//     *
//     * @param $colorId
//     * @return array
//     */
//    public function getSelectedModels($colorId): ?array
//    {
//        return connect()->table('product_colors')->select('modelId')->where('colorId', $colorId)->indexKey('articleId')->valueKey('articleId')->getAllIndexes('array');
//    }



    public function checkFileName(string $fileName)
    {
        // TODO: Implement checkFileName() method.
    }



    /** STATIC */

    /**
     * Получить цвета
     * @return array|null
     */
    public static function getColors(): ?array
    {
        return connect()->table('colors')->select('colorId, colorName')->orderBy('orderBy ASC')->getAll('array');
    }



}