<?php


namespace Mnv\Models;


use Mnv\Core\Bot\Telegram;
use Mnv\Core\Test\Log;
use Mnv\Http\Request;

class TelegramNotification
{

    /** @var string */
    protected string $table = 'telegram_notifications';


    private $error = array();
    private $ssl = false;
    private $messengers = array();
    private $messengers_text = array();
    private $version = '1.0.0';

    public $setting;
    public $telegram_proxy_data;
    public $telegram_user_data;

    public $logs = [
        0 => 'Выключены',
        1 => 'Только ошибки',
        2 => 'Полные (все запросы: успешные и ошибочные + тест уведомлений)',
    ];
    public function __construct(Request $request)
    {
        $this->setting = $request->get('telegram');
        $this->telegram_proxy_data = $request->get('telegram_proxy_data');
        $this->telegram_user_data = $request->get('telegram_user_data');

        if (isset($request->server) && (($request->server('HTTPS') == 'on') || ($request->server('HTTPS') == '1'))) {
            $this->ssl = true;
        }

    }

    public function all()
    {
        $telegram = connect($this->table)->select('codename, value')->indexKey('codename')->valueKey('value')->getAllIndexes();
        if (!empty($telegram)) {
            if (!empty($telegram['telegram_proxy_data'])) {
                $telegram['telegram_proxy_data'] = json_decode($telegram['telegram_proxy_data'], true);
            }
            $telegram['telegram_user_data'] = json_decode($telegram['telegram_user_data'], true);
        }

//        print_r($telegram);


        return $telegram;
    }

    public function update($data)
    {
        connect($this->table)->replace($data);
    }


    public function readlogs($filename)
    {
        $file = GLOBAL_ROOT . '/temp/log/' . $filename;

        if (!is_file($file)) {
            return '';
        }

        if (file_exists($file)) {
            return htmlentities(file_get_contents($file, FILE_USE_INCLUDE_PATH, null));
        } else {
            return '';
        }
    }


    public function set_webhook($key, $timeout)
    {
        $telegram = new Telegram($key, $timeout);
        $telegram->setLog( new Log('telegram.log'), 2);

//        print_r($telegram);
        if ($this->ssl) {
            $telegram->setWebhook(GLOBAL_URL . '/public/telegram.php');
        }

        $response = $telegram->getWebhookInfo();

        if (!$response) {
            if (($this->setting['proxy'] == '1') && (!empty($this->setting['proxydata']))) {
                $results = explode(';', $this->setting['proxydata']);
                foreach ($results as $proxy) {
                    if (!$response) {
                        $telegram->setProxy($proxy);
                        $response = $telegram->getBotInfo();

                        if ($response) {
                            $json['webhook'] = 'potential';
                            $json['message'] = 'Проверка прошла успешно!';
                            $json['type'] = 'success';

                            $this->editSettingValue('telegram_key', $this->setting['telegram_key']);
                            $this->editSettingValue('webhook', 'potential');
                        }
                    }
                };
            }
        } else {
            if ((isset($response['url'])) && (($response['url']) == (GLOBAL_URL . '/public/telegram.php'))) {
                $json['webhook'] = 'tg://resolve?domain=' . $telegram->getBotInfo()['username'];

                $this->editSettingValue('telegram_key', $this->setting['telegram_key']);
                $this->editSettingValue('webhook', $json['webhook']);
            } else {
                $json['webhook'] = 'potential';

                $this->editSettingValue('telegram_key', $this->setting['telegram_key']);
                $this->editSettingValue('webhook', 'potential');
            }

            $json['message'] = 'Проверка прошла успешно!';
            $json['type'] = 'success';
        }

        return $json;
    }

    public function editSettingValue($codename = '', $value = '')
    {
        $updateSetting['codename'] = $codename;
        $updateSetting['value'] = $value;

        $this->update($updateSetting);
    }

    public function users()
    {
       return connect('users')->select('userId, loginName')->in('userType', ['A', 'D'])->orderBy('userId ASC')->indexKey('userId')->getAllIndexes('array');
    }

}