<?php

namespace Mnv\Modules;

/**
 * Class Search
 * @package Mnv\Modules
 */
class Search
{
    public $success;
    public $errors;

    public $contents = [];

    public function section($query)
    {
        if (!empty($query)) {
            connect()->grouped(function($q) use ($query) {
                $q->like('name', "%" . $query . "%")
                    ->orLike('content', "%" . $query . "%")
                    ->orLike('keywords',"%" . $query . "%");
            });
        }

        $contents = connect('sections')->select('name, url')->where('topMenu', 1)->getAll('array');
        foreach ($contents as $key => $content) {
            $contents[$key]['title'] = $content['name'];
            $contents[$key]['url']   = SITE_URL . $content['url'];
        }

        return $contents;
    }

    public function content($query)
    {
        if (!empty($query)) {
            connect()->grouped(function($q) use ($query) {
                $q->like('title', "%" . $query . "%")
                    ->orLike('content', "%" . $query . "%")
                    ->orLike('keywords',"%" . $query . "%");
            });
        }

        $contents = connect('articles')->select('title, url')->getAll('array');
        foreach ($contents as $key => $content) {
            $contents[$key]['url'] = SITE_URL . $content['url'];
        }

        return $contents;
    }

}