<?php


namespace Mnv\Modules;


class Showrooms
{

    public $response = [];

    public function all()
    {
        $rooms = connect()->table('articles')
            ->select('articleId, coordinates, title, address, summary')
            ->where('typeContent', 'showrooms')
            ->where('status', 'V')
            ->orderBy('articleId ASC')
            ->getAll('array');

        $this->response['type'] = 'FeatureCollection';
        foreach ($rooms as $roomId => $room) {
            $coordinates = [];
            if (!empty($room['coordinates'])) {
                $coordinates = explode(',', $room['coordinates']);
            }

            $this->response['features'][$roomId]['type'] = 'Feature';
            $this->response['features'][$roomId]['id'] = $room['articleId'];
            $this->response['features'][$roomId]['geometry']['type'] = 'Point';
            $this->response['features'][$roomId]['geometry']['coordinates'] = $coordinates;
            $this->response['features'][$roomId]['properties']['balloonContent'] = '<h3>' . $room['title'] . '</h3> <p>' . $room['address'] . '<br><br>' . $room['summary'] . '</p>';
            $this->response['features'][$roomId]['properties']['id'] = $room['articleId'];
        }
    }
}