<?php

include '../includes/overall.inc.php';

use Mnv\Core\Bot\Telegram;
use Mnv\Core\Test\Log;
use Mnv\Core\Config;


$sapi_type = php_sapi_name();
if (substr($sapi_type, 0, 3) == 'cgi') {
    header("Status: 200 Ok'");
} else {
    header("HTTP/1.0 200 OK");
}

$request = file_get_contents('php://input');

$input = json_decode($request, true);

if (isset($input['message']/* ['text'] */)/*  && $input['message']['text'] == '/start' */) {

    $key = Config::getValue('telegram_key');
    $webhook = Config::getValue('webhook');

    if (!empty($key) && ($webhook != 'no')) {

        $telegram = new Telegram($key, $this->config->get('timeout'));
        $telegram->setLog( new Log('telegram.log'), Config::getValue('logs')['telegram']);
        $last_name = isset($input['message']['from']['last_name']) ? $input['message']['from']['last_name'] : '';
        $first_name = isset($input['message']['from']['first_name']) ? $input['message']['from']['first_name'] : '';
        $id = $input['message']['from']['id'] ? $input['message']['from']['id'] : '';
        $language_code = isset($input['message']['from']['language_code']) ? $input['message']['from']['language_code'] : '';
        $id_chat = isset($input['message']['chat']['id']) ? $input['message']['chat']['id'] : '';
        $name_chat = isset($input['message']['chat']['name']) ? $input['message']['chat']['name'] : '';

        if ($id_chat) {
            $message = 'Здравствуйте, ' . $last_name . ' ' . $first_name . '!' . chr(10) . 'ID группы ' . $name_chat . ': ' . $id_chat . ' (копировать со знаком минус в начале!)';
        } else {
            $message = 'Здравствуйте, ' . $last_name . ' ' . $first_name . '!' . chr(10) . 'Ваш ID: ' . $id . chr(10) . 'Язык: ' . $language_code;
        }

        $telegram->setTo($id);
        $telegram->sendMessage($message,  Config::getValue('trim_messages'));
    }
}
