{include file="header.tpl" title=$product.title keywords=$product.keywords description=$product.description}

<main class="main">

	<section class="flex:col">
		<div class="banner large">
			{if !empty($product.gallery)}
            {foreach from=$product.gallery item=gallery}{if $gallery.position eq 'banner'}
			<picture>
				<source srcset="{$gallery.original}" media="(max-width: 550px)" />
				<source srcset="{$gallery.original}" media="(max-width: 768px)" />
				<source srcset="{$gallery.original}" media="(max-width: 1024px)" />
				<source srcset="{$gallery.original}" media="(max-width: 1440px)" />
				<img src="{$gallery.original}" alt="{$product.title}" />
			</picture>
			{/if}{/foreach}
			{/if}

			<div class="banner__inner">
				<div class="flex:col-max">
					<div class="grid:fr-1 g-gap-40">
						<div class="text-tmp color-white title-60 txt-20 txt-fw-500">
							<h1>{$product.title}</h1>
                            {$product.summary nofilter}
						</div>

						<div class="btn-wrap">
							<button class="btn white large transparent" data-modal-id="orderModal">Заказать {include file="icon/svg.tpl" svgId="arrowTopSky" fill="none"}</button>
							<a class="btn white large" href="{$SITE_URL}/credit/">Рассрочка {include file="icon/svg.tpl" svgId="arrowTopSky" fill="none"}</a>
						</div>
					</div>
				</div>
			</div>

		</div>
	</section>

    {* Цвет *}
	{if isset($product.colors) && !empty($product.colors)}
	<section class="flex:col pad-tb-50">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">
				<div class="color-change">
					<div class="color-change__items">
						{foreach from=$product.colors item=color name=colors}
						<button class="color-change__btn color-btn_js {if $smarty.foreach.colors.first}active{/if}" style="background-image: url('{$color.preview.original}');" data-name="{$color.colorName}" data-url="{$color.image.original}"></button>
						{/foreach}
					</div>
                    {foreach from=$product.colors item=color name=colors}{if $smarty.foreach.colors.first}
					<div class="color-change__img color-img_js" data-modal-src="{$color.preview.original}" data-product-name="{$product.title}">
						<img src="{$color.image.original}" alt="{$color.colorName}">
					</div>
                    {/if}{/foreach}
				</div>
			</div>
		</div>
	</section>
	{/if}
    {* /Цвет *}

	{* Характеристики *}
	{if isset($product.features) && !empty($product.features)}
	<section class="flex:col pad-tb-50 bg-grey">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">
				<div class="characteristic">
                    {if !empty($product.gallery)}
                    {foreach from=$product.gallery item=gallery}{if $gallery.position eq 'parameter'}
					<div class="characteristic__img"><img src="{$gallery.original}" alt="Характеристики"></div>
                    {/if}{/foreach}
                    {/if}
					<div class="characteristic__list">
						<div class="text-txt title-24"><h2>Характеристики</h2></div>
						<ul>
							{foreach from=$product.features item=feature}
							<li>
								<span>{$feature.name}</span>
								<span>{$feature.value}</span>
							</li>
							{/foreach}
						</ul>

						<div class="btn-wrap">
							<button class="btn black large transparent" data-modal-id="orderModal">Заказать {include file="icon/svg.tpl" svgId="arrowTopSky" fill="none"}</button>
							<a class="btn black large" href="{$SITE_URL}/credit/">Рассрочка {include file="icon/svg.tpl" svgId="arrowTopSky" fill="none"}</a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	{/if}
    {* /Характеристики *}

	<section class="flex:col">
		<div class="banner large">
            {if !empty($product.gallery)}
                {foreach from=$product.gallery item=gallery}{if $gallery.position eq 'collection'}
				<picture>
					<source srcset="{$gallery.original}" media="(max-width: 550px)" />
					<source srcset="{$gallery.original}" media="(max-width: 768px)" />
					<source srcset="{$gallery.original}" media="(max-width: 1024px)" />
					<source srcset="{$gallery.original}" media="(max-width: 1440px)" />
					<img src="{$gallery.original}" alt="" />
				</picture>
                {/if}{/foreach}
            {/if}
			<div class="banner__inner">
				<div class="flex:col-max">
					<div class="grid:fr-1 g-gap-40 x-left max-w-800">

						<div class="text-tmp color-white title-36 img-logo">
                            {$product.content nofilter}
						</div>

						<div class="btn-wrap">
							<button class="btn white large transparent" data-modal-id="orderModal">Заказать {include file="icon/svg.tpl" svgId="arrowTopSky" fill="none"}</button>
							<a class="btn white large" href="{$SITE_URL}/credit/">Рассрочка {include file="icon/svg.tpl" svgId="arrowTopSky" fill="none"}</a>
						</div>

					</div>
				</div>
			</div>

		</div>
	</section>

    {if !empty($product.gallery)}
	<section class="flex:col">
		<div class="product-slider">

			<div class="swiper product-slider_js">
				<div class="swiper-wrapper">

                    {foreach from=$product.gallery item=gallery}{if $gallery.position eq 'gallery'}
					<div class="swiper-slide">
						<div class="product-slider__item" data-swiper-parallax="80%">
							<picture>
								<source srcset="{$gallery.original}" media="(max-width: 550px)" />
								<source srcset="{$gallery.original}" media="(max-width: 768px)" />
								<source srcset="{$gallery.original}" media="(max-width: 1024px)" />
								<source srcset="{$gallery.original}" media="(max-width: 1440px)" />
								<img src="{$gallery.original}" alt="" />
							</picture>
						</div>
					</div>
                    {/if}{/foreach}
				</div>
			</div>

			<div class="arrow-slider-container">
				<button class="arrow-slider white product-prev_js">{include file="icon/svg.tpl" svgId="arrowLeft" fill="none"}</button>
				<button class="arrow-slider white product-next_js">{include file="icon/svg.tpl" svgId="arrowRight" fill="none"}</button>
			</div>

		</div>
	</section>
    {/if}

    {if !empty($product.gallery)}
	<section class="flex:col pad-tb-50">
		<div class="grid:fr-1 g-gap-60">
            {assign var=a value=1}
            {foreach from=$product.gallery item=gallery}{if $gallery.position eq 'block'}
			<div class="deifferent {if $a eq 2}{assign var=a value=0}reverse{/if} bg-grey">
				<div class="deifferent__item">
					<div class="grid:fr-1 g-gap-40">
						<div class="text-tmp titile-36"><img src="{$gallery.original}" alt="{$gallery.title}"></div>
					</div>
				</div>

				<div class="deifferent__item">
					<div class="grid:fr-1 g-gap-40">
						<div class="text-tmp titile-36">
							<h2>{$gallery.title}</h2>
							<p>{$gallery.description nofilter}</p>
						</div>
						<a class="btn black large" href="{$SITE_URL}{$gallery.link}">{$gallery.alias}</a>
					</div>
				</div>
			</div>
                {assign var=a value=$a+1}
			{/if}{/foreach}


		</div>
	</section>
    {/if}


    {* Связаться с нами *}
    {include file="blocks/feedback.tpl" class="pad-t-50 pad-b-100 bg-grey"}
    {* /Связаться с нами *}

</main>

{include file="footer.tpl"}