<!DOCTYPE html>
<html lang="{$config.website_language}">
<head>

    {include file="modules/meta.tpl"}
	{include file="modules/link.tpl"}

    {if isset($config.yandex_metrika) && !empty($config.yandex_metrika)}
        {yandex_metrika code=$config.yandex_metrika}
    {/if}
    {if isset($config.google_analytics) && !empty($config.google_analytics) }
        {google_analytics code=$config.google_analytics}
    {/if}

</head>
<body>

{fetch_sections assign=headerMenus status="V" topMenu=1 level=1}

<header class="header  header_js">
	<div class="flex:col-max">

		<div class="header__inner">

			<div class="header__item">
				<div class="header__item-part">
					<a class="header__contact" href="tel:{$config.phone|strip_phone}">
						<span class="header__contact-icon">{include file="icon/svg.tpl" svgId="headphones" fill="none"}</span>
						<ul>
							<li>{$config.phone|format_phone}</li>
							<li>{$config.operating_mode}</li>
						</ul>
					</a>
				</div>
				<div class="header__item-part">{logo link=true classLink="header__logo"}</div>

				<div class="header__item-part">
					<div class="header__other">
						<div class="header__lang">
							<ul>
								<li>
									<button>Ru {include file="icon/svg.tpl" svgId="arrowBot" fill="none"}</button>
									<ul>
										<li><a href="{$GLOBAL_URL}/uz/">Uz</a></li>
										<li><a href="{$GLOBAL_URL}/en/">En</a></li>
									</ul>
								</li>
							</ul>
						</div>
						<button class="btn black large"  data-modal-id="measuringModal">Бесплатный замер {include file="icon/svg.tpl" svgId="measuring" fill="none"}</button>
					</div>
				</div>
			</div>

			<div class="header__item">
                {logo link=true classLink="header__nav-logo"}
				<nav>
					<ul>
                        {foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
                            {fetch_sections assign=headerSubMenus from=$headerMenu.sectionId status="V" topMenu=1 level=2}
                            {if empty($headerSubMenus)}
								<li><a href="{if !empty($headerMenu.externalLink)}{$headerMenu.externalLink}{else}{$SITE_URL}{$headerMenu.url}{/if}">{$headerMenu.alias}</a></li>
                            {else}
								<li><button class="header-btn_js">{$headerMenu.alias} {include file="icon/svg.tpl" svgId="arrowBot" fill="none"}</button></li>
                            {/if}
                        {/foreach}
					</ul>
				</nav>

				<button class="header__nav-btn call-menu-btn_js">
                    <span class="burger-btn burger-btn_cross-deg">
                        <span class="burger-btn__item"></span>
                    </span>
				</button>

			</div>

		</div>

	</div>

	<div class="header__drop-container header-drop-wrap_js">
        {foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
            {fetch_sections assign=headerSubMenus from=$headerMenu.sectionId status="V" topMenu=1 level=2 getContent=true image=true}
            {if !empty($headerSubMenus)}
                {if $smarty.foreach.headerMenus.first}
					<div class="header__drop header-drop_js">
                        {foreach item=headerSubMenu from=$headerSubMenus name=headerSubMenus}
							<div class="header__drop-card">
								<div class="header__drop-card-info">
									<div class="text-tmp txt-14">
										<p><b>{$headerSubMenu.alias}</b></p>
										<p>{$headerSubMenu.content|truncate:200 nofilter}</p>
									</div>

									<a class="btn black large" href="{$SITE_URL}{$headerSubMenu.url}">Подробнее {include file="icon/svg.tpl" svgId="arrowTopSky" fill="none"}</a>
								</div>

								<div class="header__drop-card-img">
									<img src="{$headerSubMenu.image.medium}" alt="{$headerSubMenu.alias}">
								</div>

							</div>
                        {/foreach}
					</div>
                {else}
					<div class="header__drop header-drop_js">
						<div class="header__drop-menu">
                            {foreach item=headerSubMenu from=$headerSubMenus name=headerSubMenus}
								<div class="header__drop-list">
									<ul>
										<li>{$headerSubMenu.alias}</li>
                                        {fetch_products limit=100 assign=menuProducts section=$headerSubMenu.sectionId}
                                        {foreach item=menuProduct from=$menuProducts name=menuProducts}
											<li><a href="{$SITE_URL}{$menuProduct.url}">{$menuProduct.title}</a></li>
                                        {/foreach}
									</ul>
								</div>
                            {/foreach}
						</div>
					</div>
                {/if}

            {/if}
        {/foreach}
	</div>

	{* mob *}
	<div class="header-mob header-mob_js">
		<div class="header-mob__content">
			<button class="header-mob__close header-mob-close_js">
				<svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24">
					<path d="M256-213.847 213.847-256l224-224-224-224L256-746.153l224 224 224-224L746.153-704l-224 224 224 224L704-213.847l-224-224-224 224Z" />
				</svg>
			</button>

			<div class="header-mob__head">
                {logo link=true classLink="header-mob__logo"}
				<div class="header-mob__lang">
					<ul>
						<li>Ru</li>
						<li><a href="{$GLOBAL_URL}/uz/">Uz</a></li>
						<li><a href="{$GLOBAL_URL}/en/">En</a></li>
					</ul>
				</div>
			</div>

			<div class="header-mob__menu tab_js accard_js">
                {foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
					<div class="header-mob__item">
                        {fetch_sections assign=headerSubMenus from=$headerMenu.sectionId status="V" topMenu=1 level=2}
                        {if empty($headerSubMenus)}
							<a class="header-mob__btn" href="{if !empty($headerMenu.externalLink)}{$headerMenu.externalLink}{else}{$SITE_URL}{$headerMenu.url}{/if}">{$headerMenu.alias}</a>
                        {else}
							<button class="header-mob__btn tab-btn_js">{$headerMenu.alias}</button>
							<div class="header-mob__drop tab-drop_js">
								<div class="header-mob__drop-inner">
									<ul>
                                        {foreach item=headerSubMenu from=$headerSubMenus name=headerSubMenus}
											<li><a href="{$SITE_URL}{$headerSubMenu.url}">{$headerSubMenu.alias}</a></li>
                                        {/foreach}
									</ul>
								</div>
							</div>
                        {/if}
					</div>
                {/foreach}
			</div>

			<div class="header-mob__footer">
				<div class="header-mob__phone">
					<a class="header__contact" href="tel:{$config.phone|strip_phone}">
						<span class="header__contact-icon">{include file="icon/svg.tpl" svgId="headphones" fill="none"}</span>
						<ul>
							<li>{$config.phone|format_phone}</li>
							<li>{$config.operating_mode}</li>
						</ul>
					</a>
				</div>
				<div class="social">{include file="modules/socials.tpl"}</div>
			</div>
		</div>
	</div>


    {* fixed *}
	<div class="header__fix header-fix_js">
		<div class="flex:col-max">

			<div class="header__fix-inner">
                {logo link=true classLink="header__logo"}


				<nav>
					<ul>
                        {foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
                            {fetch_sections assign=headerSubMenus from=$headerMenu.sectionId status="V" topMenu=1 level=2}
                            {if empty($headerSubMenus)}
								<li><a href="{if !empty($headerMenu.externalLink)}{$headerMenu.externalLink}{else}{$SITE_URL}{$headerMenu.url}{/if}">{$headerMenu.alias}</a></li>
                            {else}
								<li><button class="header-btn_js">{$headerMenu.alias} {include file="icon/svg.tpl" svgId="arrowBot" fill="none"}</button></li>
                            {/if}
                        {/foreach}
					</ul>
				</nav>

				<button class="btn black large"  data-modal-id="measuringModal">Бесплатный замер {include file="icon/svg.tpl" svgId="measuring" fill="none"}</button>

				<button class="header__nav-btn call-menu-btn_js">
                    <span class="burger-btn burger-btn_cross-deg">
                        <span class="burger-btn__item"></span>
                    </span>
				</button>

			</div>

		</div>
	</div>

</header>


{*<header class="header  header_js">*}
{*	<div class="flex:col-max">*}

{*		<div class="header__inner">*}

{*			<div class="header__item">*}
{*				<div class="header__item-part">*}
{*					<a class="header__contact" href="tel:{$config.phone|strip_phone}">*}
{*                        <span class="header__contact-icon">{include file="icon/svg.tpl" svgId="headphones" fill="none"}</span>*}
{*						<ul>*}
{*							<li>{$config.phone|format_phone}</li>*}
{*							<li>{$config.operating_mode}</li>*}
{*						</ul>*}
{*					</a>*}
{*				</div>*}

{*				<div class="header__item-part">{logo link=true classLink="header__logo"}</div>*}

{*				<div class="header__item-part">*}
{*					<div class="header__other">*}
{*						<div class="header__lang">*}
{*							<ul>*}
{*								<li>*}
{*									<button>Ru {include file="icon/svg.tpl" svgId="arrowBot" fill="none"}</button>*}
{*									<ul>*}
{*										<li><a href="{$GLOBAL_URL}/uz/">Uz</a></li>*}
{*										<li><a href="{$GLOBAL_URL}/en/">En</a></li>*}
{*									</ul>*}
{*								</li>*}
{*							</ul>*}
{*						</div>*}
{*						<button class="btn black large"  data-modal-id="measuringModal">Бесплатный замер {include file="icon/svg.tpl" svgId="measuring" fill="none"}</button>*}
{*					</div>*}
{*				</div>*}

{*			</div>*}

{*			<div class="header__item">*}
{*                {logo link=true classLink="header__nav-logo"}*}

{*				<nav>*}
{*					<ul>*}
{*                        {foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}*}
{*                        {fetch_sections assign=headerSubMenus from=$headerMenu.sectionId status="V" topMenu=1 level=2}*}
{*                        {if empty($headerSubMenus)}*}
{*	                        <li><a href="{if !empty($headerMenu.externalLink)}{$headerMenu.externalLink}{else}{$SITE_URL}{$headerMenu.url}{/if}">{$headerMenu.alias}</a></li>*}
{*	                    {else}*}
{*							<li><button class="header-btn_js">{$headerMenu.alias} {include file="icon/svg.tpl" svgId="arrowBot" fill="none"}</button></li>*}
{*	                    {/if}*}
{*						{/foreach}*}
{*					</ul>*}
{*				</nav>*}

{*				<button class="header__nav-btn call-menu-btn_js">*}
{*                    <span class="burger-btn burger-btn_cross-deg">*}
{*                        <span class="burger-btn__item"></span>*}
{*                    </span>*}
{*				</button>*}

{*			</div>*}

{*		</div>*}

{*	</div>*}

{*	<div class="header__drop-container header-drop-wrap_js">*}
{*        {foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}*}
{*        {fetch_sections assign=headerSubMenus from=$headerMenu.sectionId status="V" topMenu=1 level=2 getContent=true image=true}*}
{*	        {if !empty($headerSubMenus)}*}
{*		        {if $smarty.foreach.headerMenus.first}*}
{*			        <div class="header__drop header-drop_js">*}
{*                        {foreach item=headerSubMenu from=$headerSubMenus name=headerSubMenus}*}
{*							<div class="header__drop-card">*}
{*								<div class="header__drop-card-info">*}
{*									<div class="text-tmp txt-14">*}
{*										<p><b>{$headerSubMenu.alias}</b></p>*}
{*										<p>{$headerSubMenu.content|truncate:200 nofilter}</p>*}
{*									</div>*}

{*									<a class="btn black large" href="{$SITE_URL}{$headerSubMenu.url}">Подробнее {include file="icon/svg.tpl" svgId="arrowTopSky" fill="none"}</a>*}
{*								</div>*}

{*								<div class="header__drop-card-img">*}
{*									<img src="{$headerSubMenu.image.medium}" alt="{$headerSubMenu.alias}">*}
{*								</div>*}

{*							</div>*}
{*				        {/foreach}*}
{*			        </div>*}
{*		        {else}*}
{*			        <div class="header__drop header-drop_js">*}
{*				        <div class="header__drop-menu">*}
{*					        {foreach item=headerSubMenu from=$headerSubMenus name=headerSubMenus}*}
{*						        <div class="header__drop-list">*}
{*									<ul>*}
{*										<li>{$headerSubMenu.alias}</li>*}
{*                                        {fetch_products limit=100 assign=menuProducts section=$headerSubMenu.sectionId}*}
{*                                        {foreach item=menuProduct from=$menuProducts name=menuProducts}*}
{*										<li><a href="{$SITE_URL}{$menuProduct.url}">{$menuProduct.title}</a></li>*}
{*                                        {/foreach}*}
{*                                        {fetch_sections assign=headerHasSubMenus from=$headerSubMenu.sectionId status="V" topMenu=1 level=3}*}
{*										{if !empty($headerHasSubMenus)}*}
{*											<li>{$headerSubMenu.alias}</li>*}
{*                                            {foreach item=headerHasSubMenu from=$headerHasSubMenus name=headerHasSubMenus}*}
{*											<li><a href="{if !empty($headerHasSubMenu.externalLink)}{$headerHasSubMenu.externalLink}{else}{$SITE_URL}{$headerHasSubMenu.url}{/if}">{$headerHasSubMenu.alias}</a></li>*}
{*                                            {/foreach}*}
{*										{else}*}
{*											<li><a href="{if !empty($headerSubMenu.externalLink)}{$headerSubMenu.externalLink}{else}{$SITE_URL}{$headerSubMenu.url}{/if}">{$headerSubMenu.alias}</a></li>*}
{*										{/if}*}
{*									</ul>*}
{*								</div>*}
{*					        {/foreach}*}
{*				        </div>*}
{*			        </div>*}
{*		        {/if}*}

{*            {/if}*}
{*		{/foreach}*}
{*	</div>*}

{*	*}{* mob *}
{*	<div class="header-mob header-mob_js">*}
{*		<div class="header-mob__content">*}

{*			<button class="header-mob__close header-mob-close_js">*}
{*				<svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24">*}
{*					<path d="M256-213.847 213.847-256l224-224-224-224L256-746.153l224 224 224-224L746.153-704l-224 224 224 224L704-213.847l-224-224-224 224Z" />*}
{*				</svg>*}
{*			</button>*}

{*			<div class="header-mob__head">*}
{*                {logo link=true classLink="header-mob__logo"}*}

{*				<div class="header-mob__lang">*}
{*					<ul>*}
{*						<li>Ru</li>*}
{*						<li><a href="{$GLOBAL_URL}/uz/">Uz</a></li>*}
{*						<li><a href="{$GLOBAL_URL}/en/">En</a></li>*}
{*					</ul>*}
{*				</div>*}
{*			</div>*}

{*			<div class="header-mob__menu tab_js accard_js">*}
{*                {foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}*}
{*				<div class="header-mob__item">*}
{*                    {fetch_sections assign=headerSubMenus from=$headerMenu.sectionId status="V" topMenu=1 level=2}*}
{*                    {if empty($headerSubMenus)}*}
{*						<a class="header-mob__btn" href="{if !empty($headerMenu.externalLink)}{$headerMenu.externalLink}{else}{$SITE_URL}{$headerMenu.url}{/if}">{$headerMenu.alias}</a>*}
{*                    {else}*}
{*	                    <button class="header-mob__btn tab-btn_js">{$headerMenu.alias}</button>*}
{*	                    <div class="header-mob__drop tab-drop_js">*}
{*		                    <div class="header-mob__drop-inner">*}
{*			                    <ul>*}
{*                                    {foreach item=headerSubMenu from=$headerSubMenus name=headerSubMenus}*}
{*				                    <li><a href="{$SITE_URL}{$headerSubMenu.url}">{$headerSubMenu.alias}</a></li>*}
{*				                    {/foreach}*}
{*			                    </ul>*}
{*		                    </div>*}
{*	                    </div>*}
{*                    {/if}*}
{*				</div>*}
{*				{/foreach}*}
{*			</div>*}

{*			<div class="header-mob__footer">*}
{*				<div class="header-mob__phone">*}
{*					<a class="header__contact" href="tel:{$config.phone|strip_phone}">*}
{*                        <span class="header__contact-icon">{include file="icon/svg.tpl" svgId="headphones" fill="none"}</span>*}
{*						<ul>*}
{*							<li>{$config.phone|format_phone}</li>*}
{*							<li>{$config.operating_mode}</li>*}
{*						</ul>*}
{*					</a>*}
{*				</div>*}

{*				<div class="social">{include file="modules/socials.tpl"}</div>*}
{*			</div>*}

{*		</div>*}

{*	</div>*}

{*</header>*}

