{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

<main class="main">

    {fetch_section assign=productsSection section=3}{if $productsSection.status eq 'V'}
	<section class="flex:col pad-tb-50">
		<div class="flex:col-max">
            {fetch_banners assign=banners limit=10 section=$section.sectionId}{if !empty($banners)}
			<div class="intro">

				<div class="intro__category">
					<div class="intro__category-inner">
                        {foreach item=banner from=$banners name=banners}{if $smarty.foreach.banners.iteration < 7}
						<a class="small-card" href="{$banner.url}">
							<div class="small-card__img"><img src="{$banner.images.original}" alt="{$banner.title nofilter}"></div>
							<div class="text-tmp txt-fw-500"><p>{$banner.title nofilter}</p></div>
						</a>
						{/if}{/foreach}
					</div>
					<a class="btn black full" href="{$SITE_URL}{$productsSection.url}">Посмотреть все категории {include file="icon/svg.tpl" svgId="arrowTopSky" fill="none"}</a>
				</div>



				<div class="intro__slider-container">
					<div class="swiper intro__slider intro-slider_js">
						<div class="swiper-wrapper">
                            {foreach item=banner from=$banners name=banners}{if $smarty.foreach.banners.iteration > 6}
							<div class="swiper-slide">
								<div class="intro__slide">
									<div class="intro__slide-bg" data-swiper-parallax="80%"><img src="{$banner.images.original}" alt="{$banner.title nofilter}"></div>
									<div class="intro__slide-info" data-swiper-parallax="400">
										<div class="text-tmp txt-20 color-white title-50">
                                            {if !empty($banner.alias)}<p>{$banner.alias}</p>{/if}
                                            {if $smarty.foreach.banners.first}
												<h1>{$banner.title nofilter}</h1>
                                            {else}
												<h2>{$banner.title nofilter}</h2>
                                            {/if}
										</div>
									</div>
								</div>
							</div>
                            {/if}{/foreach}
						</div>
					</div>

					<div class="intro__slider-ui">
						<div class="intro__pagination"></div>
						<div class="arrow-slider-container">
							<button class="arrow-slider white intro-prev_js">{include file="icon/svg.tpl" svgId="arrowLeft" fill="none"}</button>
							<button class="arrow-slider white intro-next_js">{include file="icon/svg.tpl" svgId="arrowRight" fill="none"}</button>
						</div>
					</div>
				</div>

			</div>
            {/if}
		</div>
	</section>
    {/if}

	{* Продукция *}
    {fetch_section assign=productsSection section=3}{if $productsSection.status eq 'V'}
	<section class="flex:col pad-tb-80">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">
				<div class="text-tmp title-40"><h2>{$productsSection.name}</h2></div>
				<div class="swiper prod-slider prod-slider_js">
					<div class="swiper-wrapper">
                        {fetch_sections assign=catalogSections from=$productsSection.sectionId status="V" image=true}
                        {foreach item=subcatalog from=$catalogSections name=catalogSections}
						<div class="swiper-slide">
							<a class="prod-card" href="{$SITE_URL}{$subcatalog.url}">
								<div class="prod-card__img"><img src="{$subcatalog.image.original}" alt="{$subcatalog.name}"></div>
								<div class="prod-card__info"><div class="text-tmp title-16"><h3>{$subcatalog.name}</h3></div></div>
							</a>
						</div>
                        {/foreach}
					</div>
				</div>

				<div class="common-ui">
					<div class="arrow-slider-container">
						<button class="arrow-slider prod-prev_js">{include file="icon/svg.tpl" svgId="arrowLeft" fill="none"}</button>
						<button class="arrow-slider prod-next_js">{include file="icon/svg.tpl" svgId="arrowRight" fill="none"}</button>
					</div>
					<a class="btn black large" href="{$SITE_URL}{$productsSection.url}">Вся продукция {include file="icon/svg.tpl" svgId="arrowTopSky" fill="none"}</a>
				</div>
			</div>
		</div>
	</section>
	{/if}
    {* /Продукция *}

	{* Вызвать замерщика бесплатно *}
	<section class="flex:col border-tb ">
		<div class="flex:col-max">
			<div class="get-size max-w-1600">
				<div class="get-size__info">
					<div class="text-tmp title-30 title-tt-up"><h2><span>Вызвать замерщика</span> бесплатно</h2></div>
				</div>

				<form class="get-size__form form validation_js" action="{$SITE_URL}/ajax-call-measurer" method="post" id="getSize">
                    {include file="forms/captcha.tpl"}
					<div class="get-size__form-inner">
						<div class="input border-rad"><input type="text" name="call[fullName]" placeholder="Имя" data-empty="Обязательно для заполнения"></div>
						<div class="input border-rad"><input  type="tel" name="call[phone]" placeholder="Телефон" data-empty="Обязательно для заполнения" class="phone_js"></div>
						<input class="not-empty not-valid" type="hidden" name="call[subject]" value="Вызвать замерщика бесплатно">
						<button class="btn black large" type="submit">Отправить</button>
					</div>
				</form>
			</div>
		</div>
	</section>
    {* /Вызвать замерщика бесплатно *}


	<section class="flex:col pad-t-80 pad-b-50">
		<div class="flex:col-max">

			<div class="grid:fr-1 g-gap-40">
                {* О компании *}
                {fetch_section assign=aboutSection section=9 getContent=true}{if $aboutSection.status eq 'V'}
				<div class="desc">
					<div class="desc__info">
						<div class="logo">{logo link=false}</div>
						<div class="text-tmp">{$aboutSection.content nofilter}</div>
						<a class="btn black large" href="{$SITE_URL}{$aboutSection.url}">Подробнее {include file="icon/svg.tpl" svgId="arrowTopSky" fill="none"}</a>
					</div>

					<div class="desc__bg"><img src="{$aboutSection.image.original}" alt="{$aboutSection.name}"></div>
				</div>
				{/if}

				<div class="grid:fr-4 g-gap-20 max">

					<div class="advantage-card">
						<ul>
							<li>1000 +</li>
							<li>Опытных специалистов</li>
						</ul>
						<div class="advantage-card__img"><img src="{$ASSETS_URL}/images/icons/common/1.svg" alt=""></div>
					</div>

					<div class="advantage-card">
						<ul>
							<li>70000</li>
                            <li>м<sup>2</sup> площадь производства</li>
						</ul>
						<div class="advantage-card__img"><img src="{$ASSETS_URL}/images/icons/common/300.svg" alt=""></div>
					</div>

					<div class="advantage-card">
						<ul>
							<li>2 000 000 м2</li>
							<li>Конструкций в год</li>
						</ul>
						<div class="advantage-card__img"><img src="{$ASSETS_URL}/images/icons/common/100.svg" alt=""></div>
					</div>

					<div class="advantage-card">
						<ul>
							<li>15</li>
							<li>Роботизированных линий</li>
						</ul>
						<div class="advantage-card__img"><img src="{$ASSETS_URL}/images/icons/common/200.svg" alt=""></div>
					</div>

				</div>

			</div>

		</div>
	</section>

	{* Предложения для покупателей *}
    {fetch_section assign=buyersSection section=46}{if $buyersSection.status eq 'V'}
	<section class="flex:col pad-tb-50">
		<div class="flex:col-max">

			<div class="grid:fr-1 g-gap-40">

				<div class="text-tmp title-40">
					<h2>{$buyersSection.name|replace:'Предложения':'Предложения'}</h2>
				</div>

				<div class="grid:fr-3 g-gap-20 max">
                    {fetch_articles limit=3 assign=buyers image=true section=$buyersSection.sectionId}
                    {foreach from=$buyers item=buyer}
					<div class="offer-car">
						<div class="offer-car__img"><img src="{$buyer.image.original}" alt="{$buyer.title}"></div>
						<div class="offer-car__info">
							<div class="text-tmp title-24 title-fw-400 "><h3>{$buyer.title}</h3></div>
                            {$buyer.summary nofilter}
						</div>
					</div>
					{/foreach}
				</div>
			</div>
		</div>
	</section>
	{/if}

	<!-- конфигуратор -->

    {* Отзывы клиентов *}
    {fetch_section assign=reviewsSection section=32}{if $reviewsSection.status eq 'V'}
	<section class="flex:col pad-tb-50 bg-grey">
		<div class="flex:col-max">

			<div class="grid:fr-1 g-gap-40">

				<div class="text-tmp title-40"><h2>{$reviewsSection.name}</h2></div>
                {fetch_articles limit=2 assign=reviews image=true section=$reviewsSection.sectionId typeContent="reviews"}
				<div class="grid:fr-2 g-gap-20 max">
					{foreach from=$reviews item=review}
                        {include file="items/item-reviews.tpl"}
					{/foreach}
				</div>

				<div class="common-ui">

					<a class="btn black large x-right" href="{$SITE_URL}{$reviewsSection.url}">Все отзывы {include file="icon/svg.tpl" svgId="arrowTopSky" fill="none"}</a>

				</div>

			</div>

		</div>
	</section>
	{/if}

	<!-- новости -->
    {fetch_section assign=newsSection section=5}{if $newsSection.status eq 'V'}
	<section class="flex:col pad-tb-50">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">
				<div class="text-tmp title-40"><h2>{$newsSection.name}</h2></div>
                {fetch_articles limit=6 assign=news image=true section=$newsSection.sectionId typeContent="news"}
				<div class="swiper news-slider news-slider_js">
					<div class="swiper-wrapper">
                        {foreach from=$news item=new}
						<div class="swiper-slide">
                            {include file="items/item-news.tpl"}
						</div>
                        {/foreach}
					</div>
				</div>

				<div class="common-ui">
					<div class="arrow-slider-container">
						<button class="arrow-slider news-prev_js">{include file="icon/svg.tpl" svgId="arrowLeft" fill="none"}</button>
						<button class="arrow-slider news-next_js">{include file="icon/svg.tpl" svgId="arrowRight" fill="none"}</button>
					</div>
					<a class="btn black large" href="{$SITE_URL}{$newsSection.url}">Все новости {include file="icon/svg.tpl" svgId="arrowTopSky" fill="none"}</a>
				</div>
			</div>
		</div>
	</section>
    {/if}

	{* Партнёры *}
    {fetch_section assign=partnersSection section=33 getContent=true}{if $partnersSection.status eq 'V'}
	<section class="flex:col pad-tb-50 bg-grey">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">
				<div class="text-tmp title-40"><h2>{$partnersSection.name}</h2></div>

				{if !empty($partnersSection.gallery)}
				<div class="swiper partners-slider partners-slider_js">
					<div class="swiper-wrapper">
						{foreach from=$partnersSection.gallery item=gallery}
						<div class="swiper-slide">
							<div class="partners-card">
								<img src="{$gallery.original}" alt="{$gallery.title}">
							</div>
						</div>
						{/foreach}
					</div>
				</div>

				<div class="common-ui">
					<div class="partners-slider__pagination"></div>
				</div>
				{/if}
			</div>
		</div>
	</section>
    {/if}
    {* /Партнёры *}

    {* ШОУРУМ/КАРТА *}
    {fetch_section assign=showroomsSection section=8 getContent=true}{if $showroomsSection.status eq 'V'}
	<section class="flex:col pad-tb-50">
		<div class="flex:col-max">

			<div class="room">

				<div class="room__head">

					<div class="room__head-info">
						<div class="text-tmp title-40 txt-20">
							<h2>{$showroomsSection.name}</h2>
                            {$showroomsSection.content nofilter}
						</div>
					</div>

                    {fetch_countries assign=countries status='V' orderBy='id ASC'}
					<div class="room__head-ui">

						<div class="input">
							<div class="select-custom black border-rad select-map_js">
								<select name="" id="">
                                    {foreach from=$countries item=country}
										<option value="{$country.coordinates}">{$country.name}</option>
                                    {/foreach}
								</select>
							</div>
						</div>

						<a class="btn black large" href="{$SITE_URL}{$showroomsSection.url}">Подробнее {include file="icon/svg.tpl" svgId="arrowTopSky" fill="none"}</a>

					</div>

				</div>

				<div class="room__map" id="roomMap"></div>

				<div class="form-preloader map-preloader_js">
					<div class="form-preloader__round"></div>
				</div>

			</div>

		</div>
	</section>
	{/if}
    {* /ШОУРУМ/КАРТА *}

    {* Связаться с нами *}
	{include file="blocks/feedback.tpl" class="pad-tb-50 bg-grey"}
    {* /Связаться с нами *}

</main>

{include file="footer.tpl"}