{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

{fetch_countries assign=countries status='V' orderBy='id ASC'}

<main class="main">

	<section class="flex:col pad-tb-50">
		<div class="flex:col-max">

			<div class="room">

				<div class="text-tmp title-40 txt-20">
					<h2>{$section.name}</h2>
					{$section.content nofilter}
				</div>

				<div class="room__head">

					<div class="room__head-info">
						<div class="room__head-list">
							<ul>
								<li><a {if empty($show)}class="active"{/if} href="{$SITE_URL}{$section.url}">Карта</a></li>
								<li><a {if !empty($show) && $show eq 'list'}class="active"{/if} href="{$SITE_URL}{$section.url}?show=list">Списком</a></li>
							</ul>
						</div>
					</div>

                    {if empty($show)}
	                    {* select for maps *}
						<div class="room__head-ui">
							<div class="input">
								<div class="select-custom black border-rad select-map_js">
									<select name="" id="">
										{foreach from=$countries item=country}
										<option value="{$country.coordinates}">{$country.name}</option>
										{/foreach}
									</select>
								</div>
							</div>
						</div>
					{else}
                        {* select for list *}
						<div class="room__head-ui">
							<div class="input">
								<div class="select-custom black border-rad select-room_js">
									<select name="" id="">
                                        {foreach from=$countries item=country}
										<option value="{$country.id}">{$country.name}</option>
                                        {/foreach}
									</select>
								</div>
							</div>
						</div>
					{/if}
				</div>

                {if empty($show)}

                    {* maps *}
					<div class="room__map" id="roomMap"></div>

					<div class="form-preloader map-preloader_js">
						<div class="form-preloader__round"></div>
					</div>

	            {else}

                    {* list *}
					<div class="grid:fr-3 g-gap-20 max">
                        {fetch_articles limit=300 assign=rooms image=true fields="articleId, countryId, coordinates, title, address, summary" section=$section.sectionId}
						{foreach from=$rooms item=room}
						<div class="room-card active" data-id="{$room.countryId}">
							<div class="room-card__img"><img src="{$room.image.original}" alt="{$room.title}"></div>
							<div class="room-card__name">
								<div class="text-tmp color-white title-20 txt-fw-500"><h4>{$room.title}</h4></div>
							</div>
							<div class="room-card__info">
								<div class="text-tmp list-st-none color-white title-20 txt-fw-500">
									<h4>{$room.title nofilter}</h4>
									<p>{$room.address}</p>
									{$room.summary nofilter}
								</div>
							</div>
						</div>
						{/foreach}
					</div>

				{/if}

			</div>

		</div>
	</section>

    {* Связаться с нами *}
    {include file="blocks/feedback.tpl" class="pad-t-50 pad-b-100 bg-grey"}
    {* /Связаться с нами *}
</main>

{include file="footer.tpl"}