{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

<main class="main">

	<section class="flex:col">
		<div class="banner">
			<picture>
				<source srcset="{$section.image.medium}" media="(max-width: 550px)" />
				<source srcset="{$section.image.medium}" media="(max-width: 768px)" />
				<source srcset="{$section.image.large}" media="(max-width: 1024px)" />
				<source srcset="{$section.image.original}" media="(max-width: 1440px)" />
				<img src="{$section.image.original}" alt="{$section.name}" />
			</picture>
		</div>
	</section>

	<section class="flex:col pad-tb-50">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">

				<div class="grid:fr-1 g-gap-40">
					<div class="text-tmp title-36 max-w-800">
						<h1>{$section.name}</h1>
                        {$section.content nofilter}
					</div>

                    {* Преимущества *}
					<div class="grid:fr-3 g-gap-20 max">
                        {fetch_sections assign=advs from=37 status="V" getContent=true image=true}
                        {foreach item=adv from=$advs name=advs}
						<div class="credit-card">
							<div class="credit-card__info">
								<div class="text-tmp title-18">
									<h3>{$adv.name}</h3>
                                    {$adv.content nofilter}
								</div>
							</div>
							<div class="credit-card__icon"><img src="{$adv.image.original}" alt="{$adv.name}"></div>
						</div>
						{/foreach}
					</div>
                    {* /Преимущества *}
				</div>

				{* Как совершить покупку в рассрочку? *}
                {fetch_section assign=installmentSection section=36 getContent=true}{if $installmentSection.status eq 'V'}
				<div class="grid:fr-1 g-gap-40">
					<div class="text-tmp title-36 max-w-800"><h2>{$installmentSection.name}</h2></div>
                    {if !empty($installmentSection.content)}
					<div class="grid:fr-3 g-gap-20 max">
                        {assign var=contents value=$installmentSection.content|break}
						{foreach from=$contents item=content}
						<div class="text-tmp title-18 list-square">
                            {$content nofilter}
						</div>
						{/foreach}
					</div>
					{/if}
				</div>
                {/if}
                {* Как совершить покупку в рассрочку? *}

				{* Порядок оформления *}
                {fetch_section assign=stepSection section=38}{if $stepSection.status eq 'V'}
				<div class="grid:fr-1 g-gap-40">
					<div class="text-tmp title-36 max-w-800"><h2>{$stepSection.name}</h2></div>
					<div class="grid:fr-3 g-gap-20 max">
                        {fetch_sections assign=steps from=$stepSection.sectionId status="V" getContent=true image=true}
                        {foreach item=step from=$steps name=steps}
							<div class="credit-card">
								<div class="credit-card__info"><div class="text-tmp title-18">{$step.content nofilter}</div></div>
								<div class="credit-card__icon"><img src="{$step.image.original}" alt="{$step.name}"></div>
							</div>
                        {/foreach}
					</div>
				</div>
				{/if}
                {* /Порядок оформления *}

			</div>
		</div>
	</section>

	{* Наши банки партнеры *}
    {fetch_section assign=banksSection section=35}{if $banksSection.status eq 'V'}
	<section class="flex:col pad-tb-50">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">
				<div class="text-tmp title-36 max-w-800"><h2>{$banksSection.name}</h2></div>

                {fetch_articles limit=30 assign=banks image=true section=$banksSection.sectionId typeContent="banks"}
				<div class="grid:fr-3 max g-gap-20">
                    {foreach from=$banks item=bank}
					<div class="bank-card">
						<div class="bank-card__img"><img src="{$bank.image.original}" alt="{$bank.title}"></div>
						<div class="bank-card__info">{$bank.summary nofilter}</div>
					</div>
					{/foreach}
				</div>

				<div class="text-tmp title-36 txt-grey max-w-800">
                    {$banksSection.content nofilter}
				</div>
			</div>
		</div>
	</section>
	{/if}
    {* /Наши банки партнеры *}

    {* Связаться с нами *}
    {include file="blocks/feedback.tpl" class="pad-t-50 pad-b-100 bg-grey"}
    {* /Связаться с нами *}


</main>

{include file="footer.tpl"}