{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}
{fetch_articles limit=100 assign=jobs fields='articleId, title, alias, summary, content' image=true section=$section.sectionId typeContent="jobs"}
<main class="main">

	<section class="flex:col">

		<div class="banner">
			<picture>
				<source srcset="{$section.image.medium}" media="(max-width: 550px)" />
				<source srcset="{$section.image.medium}" media="(max-width: 768px)" />
				<source srcset="{$section.image.large}" media="(max-width: 1024px)" />
				<source srcset="{$section.image.original}" media="(max-width: 1440px)" />
				<img src="{$section.image.original}" alt="{$section.name}" />
			</picture>

		</div>

	</section>

	<div class="flex:col pad-tb-50">
		<div class="flex:col-max">

			<div class="grid:fr-1 g-gap-40 max-w-1200">

				<div class="text-tmp title-36 txt-fw-500 img-rs max-w-800">
					<h2>{$section.name}</h2>
                    {$section.content nofilter}
				</div>


				<div class="text-tmp title-36 txt-fw-500 img-rs">
					<h2>Преимущества работы в Imzo</h2>
				</div>

				<div class="grid:fr-4 g-gap-20 small">

					<div class="advant-card">
						<div class="advant-card__img"><img src="{$ASSETS_URL}/images/icons/job/1.svg" alt=""></div>
						<div class="advant-card__info">
							<ul>
                                <li>110 000 м<sup>2</sup></li>
								<li>Возможности профессионального роста</li>
							</ul>
						</div>
					</div>

					<div class="advant-card">
						<div class="advant-card__img"><img src="{$ASSETS_URL}/images/icons/job/2.svg" alt=""></div>
						<div class="advant-card__info">
							<ul>
								<li>70 000 м<sup>2</sup></li>
								<li>Дружелюбный и поддерживающий коллектив</li>
							</ul>
						</div>
					</div>

					<div class="advant-card">
						<div class="advant-card__img"><img src="{$ASSETS_URL}/images/icons/job/3.svg" alt=""></div>
						<div class="advant-card__info">
							<ul>
								<li>15</li>
								<li>Гарантированная своевременная выплата зарплаты</li>
							</ul>
						</div>
					</div>

					<div class="advant-card">
						<div class="advant-card__img"><img src="{$ASSETS_URL}/images/icons/job/4.svg" alt=""></div>
						<div class="advant-card__info">
							<ul>
								<li>2 000 000 м<sup>2</sup></li>
								<li>конструкций в год</li>
							</ul>
						</div>
					</div>

				</div>

			</div>

		</div>
	</div>


	<section class="flex:col pad-tb-50">
		<div class="flex:col-max">

			<div class="grid:fr-1 g-gap-40">

				<div class="text-tmp title-36"><h2>{$section.alias}</h2></div>

				<div class="grid:fr-4 g-gap-20 max">
					{foreach from=$jobs item=job}
					<div class="job-card">
						<div class="job-card__info">
							<div class="text-tmp title-18">
								<h3>{$job.title}</h3>
                                {$job.summary nofilter}
							</div>
							<div class="modal__info d-none"> 
								<div class="text-tmp title-36 title-dec-24 list-square">
								    <h4>{$job.title}</h4>
									{$job.content nofilter}
								</div> 
							</div>

						</div>

						<div class="job-card__city">
							<div class="text-tmp title-18 txt-grey"><p>{$job.alias}</p></div>
						</div>

						<button class="btn black large" data-modal-id="jobModal" data-job-name="{$job.title}">Подробнее {include file="icon/svg.tpl" svgId="arrowTopSky" fill="none"}</button>

					</div>
					{/foreach}

				</div>

			</div>

		</div>
	</section>

	<section class="flex:col pad-t-50 pad-b-100 bg-grey">
		<div class="flex:col-max">
			<div class="job-form">
				<div class="job-form__item">
					<div class="job-form__item-img">
						<img src="/uploads/images/e4d5cbad30a2.jpg" alt="Станьте частью команды">
					</div>
				</div>

				<div class="job-form__item">
					<div class="text-tmp title-36">
						<h2>Станьте частью команды</h2>
						<p>Направляйте резюме по адресу: hr@imzo.uz</p>
					</div>
					<form class="form validation_js" action="{$SITE_URL}/ajax-resume" method="post" id="job">
                        {include file="forms/captcha.tpl"}
						<div class="input bordr-bot">
							<input type="text" name="resume[fullName]" placeholder="ФИО *" data-empty="Обязательно для заполнения">
						</div>
						<div class="input bordr-bot">
							<input class="not-valid" type="email" name="resume[email]" placeholder="Электронная почта" data-empty="Обязательно для заполнения">
						</div>

						<div class="input bordr-bot">
							<input class="phone_js" type="tel" name="resume[phone]" placeholder="Номер телефона *" data-empty="Обязательно для заполнения">
						</div>

						<div class="file">
							<label class="file__label">
								<input class="file__input" type="file" name="file" data-type="pdf" data-error-type="Только PDF файлы" data-size="Файл не должен превышать 10мб">
								<p>Выберите файл</p>
							</label>
						</div>

						<div class="checkbox">
							<label class="checkbox__label">
								<input class="checkbox__input" type="checkbox">

								<span class="checkbox__content">
									<svg width="17" height="13" viewBox="0 0 17 13" fill="none" xmlns="http://www.w3.org/2000/svg">
										<path d="M15.0806 0L5.75806 9.20833L1.91935 5.41667L0 7.3125L5.75806 13L17 1.89583L15.0806 0Z" fill="white" />
									</svg>
								</span>

								<p>Нажимая кнопку «Отправить», вы принимаете <a href="{$SITE_URL}/privacy-policy/">условия обработки персональных данных.</a></p>
							</label>
						</div>

						<input class="not-empty" type="hidden" name="resume[subject]" value="Подача резюме">
						<button class="btn black large" type="submit">Отправить</button>

					</form>
				</div>
			</div>
		</div>
	</section>


</main>

<div class="modal-container">

	<div class="modal" id="jobModal">
		<div class="modal__inner">



			<div class="modal__form-wrap">
				<form class="modal__form form validation_js" action="{$SITE_URL}/ajax-jobs" method="post" id="jobs">
					{include file="forms/captcha.tpl"}
					<div class="input bordr-bot">
						<input type="text" placeholder="Имя" name="jobs[fullName]" data-empty="Обязательно для заполнения">
					</div>

					<div class="input bordr-bot">
						<input class="field-job-name_js not-empty" type="text" name="jobs[job]" value="{$job.title}" placeholder="Должность" data-empty="Обязательно для заполнения">
					</div>

					<div class="input bordr-bot">
						<input class="not-valid" type="email" name="jobs[email]" placeholder="Почта" data-empty="Обязательно для заполнения">
					</div>

					<div class="input bordr-bot">
						<input class="phone_js" type="text" name="jobs[phone]" placeholder="Телефон" data-empty="Обязательно для заполнения">
					</div>

					<div class="input">
						<textarea placeholder="Немного о себе" name="jobs[message]" data-empty="Обязательно для заполнения"></textarea>
					</div>

					<div class="file">
						<label class="file__label">
							<input class="file__input" type="file" name="file" data-type="" data-error-type="Только PDF файлы" data-size="Файл не должен превышать 10мб">
							<p>Прикрепить резюме</p>
						</label>
					</div>

					<div class="checkbox">
						<label class="checkbox__label">
							<input class="checkbox__input" type="checkbox">

							<span class="checkbox__content">
								<svg width="17" height="13" viewBox="0 0 17 13" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path d="M15.0806 0L5.75806 9.20833L1.91935 5.41667L0 7.3125L5.75806 13L17 1.89583L15.0806 0Z" fill="white" />
								</svg>
							</span>

							<p>Нажимая кнопку «Отправить», вы принимаете <a href="{$SITE_URL}/privacy-policy/">условия обработки персональных данных.</a></p>
						</label>
					</div>

					<input class="not-empty not-valid" type="hidden" name="jobs[subject]" value="Заявка на вакансию {$job.title}">
					<button class="btn black large" type="submit">Отправить</button>

				</form>
			</div>

		</div>
	</div>
</div>

{include file="footer.tpl"}