{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

<main class="main">

	<section class="flex:col pad-b-50">
		<div class="banner">
			<video muted="muted" autoplay loop preload playsinline>
				<source src="{$ASSETS_URL}/images/1.mp4" type="video/mp4">
			</video>

			<div class="banner__inner">

				<div class="flex:col-max">
					<div class="text-tmp color-white title-36">
						<h1>{$section.name}</h1>
					</div>
				</div>

			</div>

		</div>
	</section>


	<section class="flex:col pad-tb-50">
		<div class="flex:col-max">
            {fetch_products limit=100 assign=products section=$section.sectionId}

			<div class="grid:fr-1 g-gap-40">
				<div class="head-border">
					<div class="text-tmp title-28"><h2>{$section.name}</h2></div>
				</div>

				<div class="grid:fr-4 g-gap-20 max">
                    {foreach item=product from=$products name=products}
					<a class="product-card" href="{$SITE_URL}{$product.url}">
						<div class="product-card__img"><img src="{$product.image.original}" alt="{$product.title}"></div>
						<div class="product-card__info"><div class="text-tmp title-16"><h3>{$product.title}</h3></div></div>
					</a>
					{/foreach}
				</div>

			</div>

		</div>
	</section>


	<!-- форма -->
	<section class="flex:col border-tb ">
		<div class="flex:col-max">

			<div class="get-size max-w-1600">

				<div class="get-size__info">
					<div class="text-tmp title-30 title-tt-up">
						<h2><span>Получить персональное</span> предложение</h2>
					</div>
				</div>

				<form class="get-size__form form validation_js" action="https://www.life-style.uz/" id="getSize">

					<div class="get-size__form-inner">

						<div class="input border-rad">
							<input type="text" placeholder="Имя" data-empty="Обязательно для заполнения">
						</div>

						<div class="input border-rad">
							<input class="phone_js" type="text" placeholder="Телефон" data-empty="Обязательно для заполнения">
						</div>

						<button class="btn black large" type="submit">Отправить</button>

					</div>

				</form>

			</div>

		</div>
	</section>

    {* Связаться с нами *}
    {include file="blocks/feedback.tpl" class=" pad-t-50 pad-b-100"}
    {* /Связаться с нами *}

</main>

{include file="footer.tpl"}