{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

{fetch_articles perPage=12 assign=teams image=true section=$section.sectionId typeContent="teams" assignPagination=pagination page=$page path=$section.path seFriendly=true sectionInfo=true}
<main class="main">

	<section class="flex:col pad-tb-50">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">

				<div class="text-tmp title-36"><h1>{$section.name}</h1></div>

				<div class="grid:fr-4 g-gap-20 max">
                    {foreach from=$teams item=team}
						<div class="team-card">
							<a class="team-card__img" href="{$SITE_URL}{$team.url}"><img src="{$team.image.original}" alt="{$team.title}"></a>
							<div class="team-card__info">
								<a class="team-card__name" href="{$SITE_URL}{$team.url}">
									<ul>
										<li>{$team.title}</li>
										<li>{$team.alias}</li>
									</ul>
								</a>
								<div class="team-card__desc">{$team.summary nofilter}</div>
								<div class="team-card__contacts">
									<ul>
	                                    {if isset($team.location)}
											<li>
												<a href="">
													<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
														<path d="M12.5 1C10.2465 1.00258 8.08602 1.8726 6.49253 3.41922C4.89905 4.96584 4.00267 7.06276 4.00001 9.25C3.99731 11.0374 4.59886 12.7763 5.71237 14.2C5.71237 14.2 5.94419 14.4963 5.98205 14.539L12.5 22L19.021 14.5353C19.055 14.4955 19.2876 14.2 19.2876 14.2L19.2884 14.1978C20.4014 12.7747 21.0026 11.0366 21 9.25C20.9973 7.06276 20.1009 4.96584 18.5075 3.41922C16.914 1.8726 14.7535 1.00258 12.5 1ZM12.5 12.25C11.8887 12.25 11.2911 12.0741 10.7828 11.7444C10.2745 11.4148 9.87832 10.9462 9.64438 10.3981C9.41043 9.84987 9.34922 9.24667 9.46849 8.66473C9.58775 8.08279 9.88213 7.54824 10.3144 7.12868C10.7467 6.70912 11.2974 6.4234 11.897 6.30764C12.4966 6.19189 13.118 6.2513 13.6828 6.47836C14.2476 6.70542 14.7304 7.08994 15.07 7.58329C15.4096 8.07664 15.5909 8.65666 15.5909 9.25C15.5899 10.0453 15.2639 10.8078 14.6845 11.3702C14.105 11.9326 13.3194 12.249 12.5 12.25Z" fill="white" />
													</svg>

		                                            {$team.location}
												</a>
											</li>
										{/if}
	                                    {if isset($team.email)}
											<li>
												<a href="mailto:{$team.email}">
													<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
														<path d="M22 4H2V20H22V4ZM20 8L12 13L4 8V6L12 11L20 6V8Z" fill="white" />
													</svg>

		                                            {$team.email}
												</a>
											</li>
	                                    {/if}
	                                    {if isset($team.phone)}
											<li>
												<a href="tel:{$team.phone|strip_phone}">
													<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
														<path d="M20.0022 11H22C22 5.86943 18.1313 2 13 2V4.00022C17.0575 4.00022 20.0022 6.94355 20.0022 11Z" fill="white" />
														<path d="M13.105 7.86477C15.2301 7.86477 16.1365 8.77111 16.1365 10.896H18.1574C18.1574 7.63743 16.3638 5.84397 13.105 5.84397V7.86477ZM16.5629 13.3644C16.3687 13.1879 16.1136 13.0938 15.8513 13.1019C15.589 13.11 15.3402 13.2197 15.1573 13.4078L12.7392 15.8944C12.1572 15.7833 10.9871 15.4185 9.78259 14.2172C8.5781 13.0118 8.21332 11.8387 8.1052 11.2607L10.59 8.84183C10.7783 8.65908 10.8882 8.41021 10.8963 8.1479C10.9044 7.88558 10.8101 7.6304 10.6334 7.43636L6.89971 3.3311C6.72292 3.13645 6.47721 3.01839 6.21476 3.00197C5.95231 2.98556 5.6938 3.07209 5.49414 3.2432L3.30141 5.12355C3.12671 5.29887 3.02243 5.53221 3.00837 5.7793C2.99321 6.03191 2.70422 12.0155 7.34432 16.6573C11.3923 20.704 16.4628 21 17.8593 21C18.0634 21 18.1887 20.9939 18.2221 20.9919C18.4691 20.9781 18.7024 20.8734 18.8769 20.6979L20.7563 18.5043C20.9276 18.3048 21.0143 18.0464 20.9981 17.7839C20.9818 17.5215 20.864 17.2758 20.6694 17.0988L16.5629 13.3644Z" fill="white" />
													</svg>

		                                            {$team.phone|format_phone}
												</a>
											</li>
	                                    {/if}
									</ul>
								</div>
							</div>
						</div>
					{/foreach}
				</div>

				<div class="common-ui">
                    {include file="modules/pagination.tpl"}
				</div>
			</div>
		</div>
	</section>

    {* Связаться с нами *}
    {include file="blocks/feedback.tpl" class="pad-t-50 pad-b-100 bg-grey"}
    {* /Связаться с нами *}

</main>

{include file="footer.tpl"}